/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.handle.UUIDPersistentHandle;
import org.hypergraphdb.peer.serializer.DefaultSerializerManager;
import org.hypergraphdb.peer.serializer.HGSerializer;
import org.hypergraphdb.peer.serializer.SerializationUtils;

public class PersistentHandlerSerializer
implements HGSerializer {
    @Override
    public Object readData(InputStream in) {
        return PersistentHandlerSerializer.deserializePersistentHandle(in);
    }

    @Override
    public void writeData(OutputStream out, Object data) {
        SerializationUtils.serializeInt(out, DefaultSerializerManager.PERSISTENT_HANDLE_SERIALIZER_ID);
        PersistentHandlerSerializer.serializePersistentHandle(out, data);
    }

    public static void serializePersistentHandle(OutputStream out, Object data) {
        try {
            out.write(((HGPersistentHandle)data).toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static HGPersistentHandle deserializePersistentHandle(InputStream in) {
        byte[] data = new byte[16];
        try {
            for (int i = 0; i < data.length; i += in.read(data, i, data.length - i)) {
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return UUIDPersistentHandle.makeHandle(data);
    }
}

