/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer.serializer;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.hypergraphdb.peer.serializer.CustomSerializedValue;

public class JSONReader {
    private static final Object OBJECT_END = new Object();
    private static final Object ARRAY_END = new Object();
    private static final Object COLON = new Object();
    private static final Object COMMA = new Object();
    public static final int FIRST = 0;
    public static final int CURRENT = 1;
    public static final int NEXT = 2;
    private HashMap<Integer, CustomSerializedValue> customValues = new HashMap();
    private static Map<Character, Character> escapes = new HashMap<Character, Character>();
    private CharacterIterator it;
    private char c;
    private Object token;
    private StringBuffer buf = new StringBuffer();

    private char next() {
        if (this.it.getIndex() == this.it.getEndIndex()) {
            throw new RuntimeException("Reached end of input at the " + this.it.getIndex() + "th character.");
        }
        this.c = this.it.next();
        return this.c;
    }

    private char previous() {
        this.c = this.it.previous();
        return this.c;
    }

    private void skipWhiteSpace() {
        do {
            if (Character.isWhitespace(this.c)) continue;
            if (this.c != '/') break;
            this.next();
            if (this.c == '*') {
                while (this.c != '\uffff' && (this.next() != '*' || this.next() != '/')) {
                }
                if (this.c != '\uffff') continue;
                throw new RuntimeException("Unterminated comment while parsing JSON string.");
            }
            if (this.c == '/') {
                while (this.c != '\n' && this.c != '\uffff') {
                    this.next();
                }
            } else {
                this.previous();
                break;
            }
        } while (this.next() != '\uffff');
    }

    public Object read(CharacterIterator ci, int start) {
        this.it = ci;
        switch (start) {
            case 0: {
                this.c = this.it.first();
                break;
            }
            case 1: {
                this.c = this.it.current();
                break;
            }
            case 2: {
                this.c = this.it.next();
            }
        }
        return this.read();
    }

    public Object read(CharacterIterator it) {
        return this.read(it, 2);
    }

    public Object read(String string) {
        return this.read(new StringCharacterIterator(string), 0);
    }

    private Object read() {
        this.skipWhiteSpace();
        char ch = this.c;
        this.next();
        switch (ch) {
            case '\"': {
                this.token = this.string();
                break;
            }
            case '[': {
                this.token = this.array();
                break;
            }
            case ']': {
                this.token = ARRAY_END;
                break;
            }
            case ',': {
                this.token = COMMA;
                break;
            }
            case '{': {
                this.token = this.object();
                break;
            }
            case '}': {
                this.token = OBJECT_END;
                break;
            }
            case ':': {
                this.token = COLON;
                break;
            }
            case 't': {
                if (this.c != 'r' || this.next() != 'u' || this.next() != 'e') {
                    throw new RuntimeException("Invalid JSON token: expected 'true' keyword.");
                }
                this.next();
                this.token = Boolean.TRUE;
                break;
            }
            case 'f': {
                if (this.c != 'a' || this.next() != 'l' || this.next() != 's' || this.next() != 'e') {
                    throw new RuntimeException("Invalid JSON token: expected 'false' keyword.");
                }
                this.next();
                this.token = Boolean.FALSE;
                break;
            }
            case 'n': {
                if (this.c != 'u' || this.next() != 'l' || this.next() != 'l') {
                    throw new RuntimeException("Invalid JSON token: expected 'null' keyword.");
                }
                this.next();
                this.token = null;
                break;
            }
            default: {
                this.c = this.it.previous();
                if (!Character.isDigit(this.c) && this.c != '-') break;
                this.token = this.number();
            }
        }
        return this.token;
    }

    private Object object() {
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        Object key = this.read();
        while (this.token != OBJECT_END) {
            this.read();
            if (this.token == OBJECT_END) continue;
            ret.put(key, this.read());
            if (this.read() != COMMA) continue;
            key = this.read();
        }
        return ret;
    }

    private Object array() {
        Object pos;
        ArrayList<Object> ret = new ArrayList<Object>();
        Object value = this.read();
        while (this.token != ARRAY_END) {
            ret.add(value);
            if (this.read() == COMMA) {
                value = this.read();
                continue;
            }
            if (this.token == ARRAY_END) continue;
            throw new RuntimeException("Unexpected token in array " + this.token);
        }
        if (ret.size() == 2 && ret.get(0) != null && ret.get(0).equals("custom") && ret.get(1) instanceof Map && ((Map)ret.get(1)).containsKey("pos") && (pos = ((Map)ret.get(1)).get("pos")) instanceof Long) {
            CustomSerializedValue customValue = new CustomSerializedValue();
            this.customValues.put(((Long)pos).intValue(), customValue);
            return customValue;
        }
        return ret;
    }

    private Object number() {
        int length = 0;
        boolean isFloatingPoint = false;
        this.buf.setLength(0);
        if (this.c == '-') {
            this.add();
        }
        length += this.addDigits();
        if (this.c == '.') {
            this.add();
            length += this.addDigits();
            isFloatingPoint = true;
        }
        if (this.c == 'e' || this.c == 'E') {
            this.add();
            if (this.c == '+' || this.c == '-') {
                this.add();
            }
            this.addDigits();
            isFloatingPoint = true;
        }
        String s = this.buf.toString();
        return isFloatingPoint ? (Number)(length < 17 ? Double.valueOf(s) : new BigDecimal(s)) : (Number)(length < 20 ? Long.valueOf(s) : new BigInteger(s));
    }

    private int addDigits() {
        int ret = 0;
        while (Character.isDigit(this.c)) {
            this.add();
            ++ret;
        }
        return ret;
    }

    private Object string() {
        this.buf.setLength(0);
        while (this.c != '\"') {
            if (this.c == '\\') {
                this.next();
                if (this.c == 'u') {
                    this.add(this.unicode());
                    continue;
                }
                Character value = escapes.get(new Character(this.c));
                if (value == null) continue;
                this.add(value.charValue());
                continue;
            }
            this.add();
        }
        this.next();
        return this.buf.toString();
    }

    private void add(char cc) {
        this.buf.append(cc);
        this.next();
    }

    private void add() {
        this.add(this.c);
    }

    private char unicode() {
        int value = 0;
        block5: for (int i = 0; i < 4; ++i) {
            switch (this.next()) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    value = (value << 4) + this.c - 48;
                    continue block5;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    value = (value << 4) + (this.c - 97) + 10;
                    continue block5;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    value = (value << 4) + (this.c - 65) + 10;
                }
            }
        }
        return (char)value;
    }

    public HashMap<Integer, CustomSerializedValue> getCustomValues() {
        return this.customValues;
    }

    static {
        escapes.put(new Character('\"'), new Character('\"'));
        escapes.put(new Character('\\'), new Character('\\'));
        escapes.put(new Character('/'), new Character('/'));
        escapes.put(new Character('b'), new Character('\b'));
        escapes.put(new Character('f'), new Character('\f'));
        escapes.put(new Character('n'), new Character('\n'));
        escapes.put(new Character('r'), new Character('\r'));
        escapes.put(new Character('t'), new Character('\t'));
    }
}

