/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer.replication;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.peer.HGPeerIdentity;
import org.hypergraphdb.peer.HyperGraphPeer;
import org.hypergraphdb.peer.Message;
import org.hypergraphdb.peer.Messages;
import org.hypergraphdb.peer.StorageService;
import org.hypergraphdb.peer.Structs;
import org.hypergraphdb.peer.log.Timestamp;
import org.hypergraphdb.peer.workflow.AbstractActivity;
import org.hypergraphdb.peer.workflow.Conversation;
import org.hypergraphdb.peer.workflow.ProposalConversation;
import org.hypergraphdb.peer.workflow.TaskActivity;
import org.hypergraphdb.peer.workflow.TaskFactory;
import org.hypergraphdb.storage.StorageGraph;

public class RememberTaskServer
extends TaskActivity<State> {
    private Timestamp last_version;
    private Timestamp current_version;
    private StorageService storage;

    public RememberTaskServer(HyperGraphPeer thisPeer, StorageService storage, UUID taskId) {
        super(thisPeer, taskId, State.Started, State.Done);
        this.storage = storage;
        this.registerConversationHandler(State.BeforeStart, (Object)ProposalConversation.State.Started, "doPropose", State.Started);
        this.registerConversationHandler(State.Started, (Object)ProposalConversation.State.Accepted, "handleAccept", State.HandleAccepted);
        this.registerConversationHandler(State.Started, (Object)ProposalConversation.State.Rejected, "handleReject", State.HandleRejected);
    }

    @Override
    protected Conversation<?> createNewConversation(Message msg) {
        return new ProposalConversation(this, Messages.getSender(msg));
    }

    public State doPropose(AbstractActivity<?> conversation) {
        ProposalConversation conv = (ProposalConversation)conversation;
        this.last_version = (Timestamp)Structs.getPart(conv.getMessage(), "content", "last_version");
        this.current_version = (Timestamp)Structs.getPart(conv.getMessage(), "content", "curr_version");
        Message reply = Messages.getReply(conv.getMessage());
        conv.propose(reply);
        return State.Started;
    }

    public State handleAccept(AbstractActivity<?> conversation) {
        System.out.println("RememberActivityServer: acccepting");
        ProposalConversation conv = (ProposalConversation)conversation;
        Message msg = ((Conversation)conversation).getMessage();
        ArrayList<Object> handles = new ArrayList<Object>();
        HGPeerIdentity peerId = this.getPeerInterface().getThisPeer().getIdentity(Structs.getPart(msg, "reply-to"));
        if (this.getThisPeer().getLog().registerRequest(peerId, this.last_version, this.current_version)) {
            ArrayList contents = (ArrayList)Structs.getPart(msg, "content");
            for (Object content : contents) {
                StorageGraph subgraph;
                StorageService.Operation operation = StorageService.Operation.valueOf((String)Structs.getPart(content, "operation"));
                HGHandle handle = null;
                if (operation == StorageService.Operation.Create) {
                    subgraph = (StorageGraph)Structs.getPart(content, "content");
                    handle = this.storage.addSubgraph(subgraph);
                } else if (operation == StorageService.Operation.Update) {
                    subgraph = (StorageGraph)Structs.getPart(content, "content");
                    handle = this.storage.updateSubgraph(subgraph);
                } else if (operation == StorageService.Operation.Remove) {
                    handle = (HGPersistentHandle)Structs.getPart(content, "content");
                    this.storage.remove(handle);
                } else if (operation == StorageService.Operation.Copy) {
                    subgraph = (StorageGraph)Structs.getPart(content, "content");
                    handle = this.storage.addOrReplaceSubgraph(subgraph);
                }
                handles.add(Structs.svalue(handle));
            }
            this.getThisPeer().getLog().finishRequest(peerId, this.last_version, this.current_version);
            System.out.println("RememberActivityServer: remembered " + handles);
            Message reply = Messages.getReply(msg);
            Structs.combine(reply, Structs.struct("content", handles));
            conv.confirm(reply);
        } else {
            Message reply = Messages.getReply(msg);
            conv.disconfirm(reply);
        }
        return State.Done;
    }

    public State handleReject(AbstractActivity<?> conversation) {
        return State.Done;
    }

    public static class RememberTaskServerFactory
    implements TaskFactory {
        private Map<HyperGraphPeer, StorageService> storage = new HashMap<HyperGraphPeer, StorageService>();

        private synchronized StorageService getStorage(HyperGraphPeer peer) {
            StorageService ss = this.storage.get(peer);
            if (ss == null) {
                ss = new StorageService(peer);
                this.storage.put(peer, ss);
            }
            return ss;
        }

        @Override
        public TaskActivity<?> newTask(HyperGraphPeer peer, UUID taskId, Object msg) {
            return new RememberTaskServer(peer, this.getStorage(peer), taskId);
        }
    }

    protected static enum State {
        BeforeStart,
        Started,
        HandleAccepted,
        HandleRejected,
        Done;

    }
}

