/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer.replication;

import java.util.Iterator;
import java.util.UUID;
import org.hypergraphdb.peer.HyperGraphPeer;
import org.hypergraphdb.peer.Message;
import org.hypergraphdb.peer.Messages;
import org.hypergraphdb.peer.PeerFilter;
import org.hypergraphdb.peer.PeerRelatedActivity;
import org.hypergraphdb.peer.PeerRelatedActivityFactory;
import org.hypergraphdb.peer.Performative;
import org.hypergraphdb.peer.Structs;
import org.hypergraphdb.peer.replication.Replication;
import org.hypergraphdb.peer.workflow.Activity;
import org.hypergraphdb.query.HGAtomPredicate;

public class PublishInterestsTask
extends Activity {
    private HGAtomPredicate pred;

    public PublishInterestsTask(HyperGraphPeer thisPeer, HGAtomPredicate pred) {
        super(thisPeer);
        this.pred = pred;
    }

    public PublishInterestsTask(HyperGraphPeer thisPeer, UUID id) {
        super(thisPeer, id);
        this.pred = Replication.get(thisPeer).getAtomInterests();
    }

    @Override
    public void initiate() {
        PeerRelatedActivityFactory activityFactory = this.getPeerInterface().newSendActivityFactory();
        PeerFilter peerFilter = this.getPeerInterface().newFilterActivity(null);
        peerFilter.filterTargets();
        Iterator<Object> it = peerFilter.iterator();
        while (it.hasNext()) {
            Object target = it.next();
            this.sendMessage(activityFactory, target);
        }
        this.getState().setCompleted();
    }

    @Override
    public void handleMessage(Message msg) {
        Object sendToTarget = Structs.getPart(msg, "reply-to");
        this.sendMessage(this.getPeerInterface().newSendActivityFactory(), sendToTarget);
        this.getState().setCompleted();
    }

    private void sendMessage(PeerRelatedActivityFactory activityFactory, Object target) {
        Message msg = Messages.createMessage(Performative.Inform, "atom_interest", this.getId());
        Structs.combine(msg, Structs.struct("content", this.pred));
        PeerRelatedActivity activity = activityFactory.createActivity();
        activity.setTarget(target);
        activity.setMessage(msg);
        this.getThisPeer().getExecutorService().submit(activity);
    }
}

