/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer.replication;

import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.hypergraphdb.peer.HGPeerIdentity;
import org.hypergraphdb.peer.HyperGraphPeer;
import org.hypergraphdb.peer.Message;
import org.hypergraphdb.peer.Messages;
import org.hypergraphdb.peer.PeerFilter;
import org.hypergraphdb.peer.PeerRelatedActivity;
import org.hypergraphdb.peer.PeerRelatedActivityFactory;
import org.hypergraphdb.peer.Performative;
import org.hypergraphdb.peer.Structs;
import org.hypergraphdb.peer.replication.Replication;
import org.hypergraphdb.peer.workflow.Activity;
import org.hypergraphdb.query.HGAtomPredicate;

public class GetInterestsTask
extends Activity {
    private AtomicInteger count = new AtomicInteger();

    public GetInterestsTask(HyperGraphPeer thisPeer) {
        super(thisPeer);
    }

    public GetInterestsTask(HyperGraphPeer thisPeer, UUID taskId) {
        super(thisPeer, taskId);
    }

    @Override
    public void initiate() {
        PeerRelatedActivityFactory activityFactory = this.getPeerInterface().newSendActivityFactory();
        PeerFilter peerFilter = this.getPeerInterface().newFilterActivity(null);
        peerFilter.filterTargets();
        Iterator<Object> it = peerFilter.iterator();
        this.count.set(1);
        while (it.hasNext()) {
            this.count.incrementAndGet();
            Object target = it.next();
            this.sendMessage(activityFactory, target);
        }
        if (this.count.decrementAndGet() == 0) {
            this.getState().setCompleted();
        }
    }

    private void sendMessage(PeerRelatedActivityFactory activityFactory, Object target) {
        Message msg = Messages.createMessage(Performative.Request, "atom_interest", this.getId());
        PeerRelatedActivity activity = activityFactory.createActivity();
        activity.setTarget(target);
        activity.setMessage(msg);
        try {
            this.getThisPeer().getExecutorService().submit(activity);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void handleMessage(Message msg) {
        HGPeerIdentity other = this.getThisPeer().getIdentity(Structs.getPart(msg, "reply-to"));
        Replication.get(this.getThisPeer()).getOthersInterests().put(other, (HGAtomPredicate)Structs.getPart(msg, "content"));
        if (this.count.decrementAndGet() == 0) {
            this.getState().setCompleted();
        }
    }
}

