/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer.cact;

import java.util.UUID;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.peer.HGPeerIdentity;
import org.hypergraphdb.peer.HyperGraphPeer;
import org.hypergraphdb.peer.Message;
import org.hypergraphdb.peer.Messages;
import org.hypergraphdb.peer.Performative;
import org.hypergraphdb.peer.Structs;
import org.hypergraphdb.peer.workflow.FSMActivity;
import org.hypergraphdb.peer.workflow.FromState;
import org.hypergraphdb.peer.workflow.OnMessage;
import org.hypergraphdb.peer.workflow.PossibleOutcome;
import org.hypergraphdb.peer.workflow.WorkflowState;
import org.hypergraphdb.peer.workflow.WorkflowStateConstant;

public class GetClassForType
extends FSMActivity {
    public static final String TYPENAME = "get-class-for-type";
    private HGPeerIdentity target;
    private HGHandle typeHandle;
    private String className;

    public GetClassForType(HyperGraphPeer thisPeer, HGHandle typeHandle, Object target) {
        super(thisPeer);
        this.target = target instanceof HGPeerIdentity ? (HGPeerIdentity)target : thisPeer.getIdentity(target);
        this.typeHandle = typeHandle;
    }

    public GetClassForType(HyperGraphPeer thisPeer, UUID id) {
        super(thisPeer, id);
    }

    @Override
    public void initiate() {
        Message msg = Messages.createMessage(Performative.QueryRef, this);
        Structs.combine(msg, Structs.struct("content", this.typeHandle));
        this.send(this.target, msg);
    }

    @FromState(value={"Started"})
    @OnMessage(performative="QueryRef")
    @PossibleOutcome(value={"Completed"})
    public WorkflowStateConstant onQuery(Message msg) {
        this.typeHandle = (HGHandle)Structs.getPart(msg, "content");
        Class<?> clazz = this.getThisPeer().getGraph().getTypeSystem().getClassForType(this.typeHandle);
        if (clazz != null) {
            this.send(Messages.getSender(msg), Messages.getReply(msg, Performative.Inform, clazz.getName()));
        } else {
            this.send(Messages.getSender(msg), Messages.getReply(msg, Performative.Refuse));
        }
        return WorkflowState.Completed;
    }

    @FromState(value={"Started"})
    @OnMessage(performative="Inform")
    @PossibleOutcome(value={"Completed"})
    public WorkflowStateConstant onInform(Message msg) {
        this.className = (String)Structs.getPart(msg, "content");
        return WorkflowState.Completed;
    }

    @FromState(value={"Started"})
    @OnMessage(performative="Refuse")
    @PossibleOutcome(value={"Failed"})
    public WorkflowStateConstant onRefuse(Message msg) {
        return WorkflowState.Failed;
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    public String getType() {
        return TYPENAME;
    }
}

