/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer.cact;

import java.util.UUID;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.peer.HGPeerIdentity;
import org.hypergraphdb.peer.HyperGraphPeer;
import org.hypergraphdb.peer.Message;
import org.hypergraphdb.peer.Messages;
import org.hypergraphdb.peer.Performative;
import org.hypergraphdb.peer.Structs;
import org.hypergraphdb.peer.SubgraphManager;
import org.hypergraphdb.peer.workflow.FSMActivity;
import org.hypergraphdb.peer.workflow.FromState;
import org.hypergraphdb.peer.workflow.OnMessage;
import org.hypergraphdb.peer.workflow.PossibleOutcome;
import org.hypergraphdb.peer.workflow.WorkflowState;
import org.hypergraphdb.peer.workflow.WorkflowStateConstant;

public class DefineAtom
extends FSMActivity {
    public static final String TYPENAME = "define-atom";
    private HGPeerIdentity target;
    private HGHandle atom;

    public DefineAtom(HyperGraphPeer thisPeer, UUID id) {
        super(thisPeer, id);
    }

    public DefineAtom(HyperGraphPeer thisPeer, HGHandle atom, HGPeerIdentity target) {
        super(thisPeer);
        this.atom = atom;
        this.target = target;
    }

    @Override
    public void initiate() {
        Message msg = Messages.createMessage(Performative.Request, this);
        Structs.combine(msg, Structs.struct("content", SubgraphManager.getTransferAtomRepresentation(this.getThisPeer().getGraph(), this.atom)));
        this.send(this.target, msg);
    }

    @FromState(value={"Started"})
    @OnMessage(performative="Request")
    @PossibleOutcome(value={"Completed"})
    public WorkflowStateConstant onRequestDefine(Message msg) throws Throwable {
        SubgraphManager.writeTransferedGraph(Structs.getPart(msg, "content"), this.getThisPeer().getGraph());
        Message reply = Messages.getReply(msg, Performative.Agree);
        this.send(Messages.getSender(msg), reply);
        return WorkflowState.Completed;
    }

    @FromState(value={"Started"})
    @OnMessage(performative="Agree")
    @PossibleOutcome(value={"Completed"})
    public WorkflowStateConstant onAgree(Message msg) {
        return WorkflowStateConstant.Completed;
    }

    @Override
    public String getType() {
        return TYPENAME;
    }
}

