/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer;

import java.util.Map;
import java.util.UUID;
import org.hypergraphdb.peer.Message;
import org.hypergraphdb.peer.Performative;
import org.hypergraphdb.peer.Structs;
import org.hypergraphdb.peer.workflow.Activity;

public class Messages {
    public static final String PERFORMATIVE = "performative";
    public static final String IN_REPLY_TO = "in-reply-to";
    public static final String REPLY_WITH = "reply-with";
    public static final String CONTENT = "content";
    public static final String LANGUAGE = "language";
    public static final String OPERATION = "operation";
    public static final String REPLY_TO = "reply-to";
    public static final String CONVERSATION_ID = "conversation-id";
    public static final String PARENT_SCOPE = "x-parent-scope";
    public static final String ACTIVITY_TYPE = "x-activity-type";

    public static Message createMessage(Performative performative, Activity activity) {
        return Messages.createMessage(performative, activity.getType(), activity.getId());
    }

    public static Message createMessage(Performative performative, String type, UUID activityId) {
        return new Message(Structs.struct(PERFORMATIVE, performative, ACTIVITY_TYPE, type, CONVERSATION_ID, activityId));
    }

    public static Message getReply(Message msg, Performative performative, Object content) {
        return Structs.combine(Messages.getReply(msg, performative), Structs.struct(CONTENT, content));
    }

    public static Message getReply(Message msg, Performative performative) {
        return Structs.combine(Messages.getReply(msg), Structs.struct(PERFORMATIVE, performative));
    }

    public static Message makeReply(Activity activity, Performative performative, String replyWith) {
        Map<String, Object> s = Structs.struct(ACTIVITY_TYPE, activity.getType(), CONVERSATION_ID, activity.getId(), PERFORMATIVE, performative);
        if (replyWith != null) {
            return new Message(Structs.combine(s, Structs.struct(IN_REPLY_TO, replyWith)));
        }
        return new Message(s);
    }

    public static Message getReply(Message msg) {
        Map<String, Object> s = Structs.struct(ACTIVITY_TYPE, Structs.getPart(msg, ACTIVITY_TYPE), CONVERSATION_ID, Structs.getPart(msg, CONVERSATION_ID));
        String replyWith = (String)Structs.getPart(msg, REPLY_WITH);
        if (replyWith != null) {
            return new Message(Structs.combine(s, Structs.struct(IN_REPLY_TO, replyWith)));
        }
        return new Message(s);
    }

    public static Object getSender(Message msg) {
        return Structs.getPart(msg, REPLY_TO);
    }
}

