/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.hypergraphdb.HGEnvironment;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HGQuery;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.peer.BootstrapPeer;
import org.hypergraphdb.peer.HGPeerIdentity;
import org.hypergraphdb.peer.NetworkPeerPresenceListener;
import org.hypergraphdb.peer.PeerInterface;
import org.hypergraphdb.peer.PeerPresenceListener;
import org.hypergraphdb.peer.PrivatePeerIdentity;
import org.hypergraphdb.peer.Structs;
import org.hypergraphdb.peer.bootstrap.AffirmIdentityBootstrap;
import org.hypergraphdb.peer.log.Log;
import org.hypergraphdb.peer.replication.GetInterestsTask;
import org.hypergraphdb.peer.serializer.GenericSerializer;
import org.hypergraphdb.peer.serializer.JSONReader;
import org.hypergraphdb.peer.workflow.ActivityManager;
import org.hypergraphdb.peer.workflow.ActivityResult;
import org.hypergraphdb.peer.workflow.AffirmIdentity;
import org.hypergraphdb.storage.HGStoreSubgraph;
import org.hypergraphdb.storage.StorageGraph;
import org.hypergraphdb.transaction.HGTransactionConfig;
import org.hypergraphdb.util.HGUtils;
import org.hypergraphdb.util.TwoWayMap;

public class HyperGraphPeer {
    private Map<String, Object> configuration;
    private PeerInterface peerInterface = null;
    private ActivityManager activityManager = null;
    private Map<String, Object> context = Collections.synchronizedMap(new HashMap());
    private HyperGraph graph = null;
    private HGPeerIdentity identity = null;
    private TwoWayMap<Object, HGPeerIdentity> peerIdentities = new TwoWayMap();
    private List<PeerPresenceListener> peerListeners = new ArrayList<PeerPresenceListener>();
    private HyperGraph tempGraph = null;
    private Log log;
    private ExecutorService executorService = null;

    private void init() {
        Number threadPoolSize = (Number)this.configuration.get("threadPoolSize");
        this.executorService = threadPoolSize == null || threadPoolSize.intValue() <= 0 ? Executors.newCachedThreadPool() : Executors.newFixedThreadPool(threadPoolSize.intValue());
        this.activityManager = new ActivityManager(this);
    }

    public HyperGraphPeer(Map<String, Object> configuration) {
        this.configuration = configuration;
    }

    public HyperGraphPeer(Map<String, Object> configuration, HyperGraph graph) {
        this(configuration);
        this.graph = graph;
    }

    public HyperGraphPeer(File configFile) {
        this.loadConfig(configFile);
    }

    public HyperGraphPeer(File configFile, HyperGraph graph) {
        this(configFile);
        this.graph = graph;
    }

    public static HGPeerIdentity getIdentity(final HyperGraph graph, String peerName) {
        HGPeerIdentity identity = null;
        InetAddress localMachine = null;
        try {
            localMachine = InetAddress.getLocalHost();
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace(System.err);
        }
        List all = HGQuery.hg.getAll(graph, HGQuery.hg.type(PrivatePeerIdentity.class));
        if (all.isEmpty()) {
            PrivatePeerIdentity id = new PrivatePeerIdentity();
            id.setId(graph.getHandleFactory().makeHandle());
            id.setGraphLocation(graph.getLocation());
            id.setHostname(localMachine.getHostName());
            id.setIpAddress(localMachine.getHostAddress());
            id.setName(peerName);
            graph.define(id.getId(), id);
            identity = id.makePublicIdentity();
            return identity;
        }
        if (all.size() > 1) {
            throw new RuntimeException("More than one identity on peer - a bug or a malicious activity.");
        }
        final PrivatePeerIdentity pid = (PrivatePeerIdentity)all.get(0);
        if (!HGUtils.eq(pid.getName(), peerName)) {
            pid.setName(peerName);
            graph.update(pid);
        }
        if (!(HGUtils.eq((identity = pid.makePublicIdentity()).getHostname(), localMachine.getHostName()) && HGUtils.eq(identity.getIpAddress(), localMachine.getHostAddress()) && HGUtils.eq(identity.getGraphLocation(), graph.getLocation()))) {
            final InetAddress machine = localMachine;
            identity = graph.getTransactionManager().transact(new Callable<HGPeerIdentity>(){

                @Override
                public HGPeerIdentity call() {
                    graph.remove(pid.getId());
                    HGPersistentHandle newId = graph.getHandleFactory().makeHandle();
                    pid.setId(newId);
                    pid.setGraphLocation(graph.getLocation());
                    pid.setHostname(machine.getHostName());
                    pid.setIpAddress(machine.getHostAddress());
                    graph.define(newId, pid);
                    return pid.makePublicIdentity();
                }
            }, HGTransactionConfig.DEFAULT);
        }
        return identity;
    }

    public HGPeerIdentity getIdentity() {
        if (this.identity != null) {
            return this.identity;
        }
        if (this.graph == null) {
            throw new RuntimeException("Can't get peer identity because this peer is not bound to a graph.");
        }
        return HyperGraphPeer.getIdentity(this.graph, Structs.getOptPart(this.configuration, "HGDBPeer", "peerName"));
    }

    private void loadConfig(File configFile) {
        this.configuration = HyperGraphPeer.loadConfiguration(configFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getContents(File file) throws IOException {
        StringBuilder contents = new StringBuilder();
        BufferedReader input = new BufferedReader(new FileReader(file));
        try {
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.append(line);
                contents.append(System.getProperty("line.separator"));
            }
        }
        finally {
            input.close();
        }
        return contents.toString();
    }

    public static Map<String, Object> loadConfiguration(File configFile) {
        JSONReader reader = new JSONReader();
        try {
            return (Map)Structs.getPart(reader.read(HyperGraphPeer.getContents(configFile)), new Object[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Future<Boolean> start(String user, String passwd) {
        this.init();
        return this.executorService.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                boolean status = false;
                if (HyperGraphPeer.this.configuration != null) {
                    try {
                        String option = Structs.getOptPart(HyperGraphPeer.this.configuration, null, "tempDB");
                        if (!HGUtils.isEmpty(option)) {
                            HyperGraphPeer.this.tempGraph = HGEnvironment.get(option);
                            GenericSerializer.setTempDB(HyperGraphPeer.this.tempGraph);
                        }
                        option = Structs.getOptPart(HyperGraphPeer.this.configuration, null, "localDB");
                        if (HyperGraphPeer.this.graph == null && !HGUtils.isEmpty(option)) {
                            HyperGraphPeer.this.graph = HGEnvironment.get(option);
                        }
                        String peerInterfaceType = (String)Structs.getPart(HyperGraphPeer.this.configuration, "interfaceType");
                        HyperGraphPeer.this.peerInterface = (PeerInterface)Class.forName(peerInterfaceType).getConstructor(new Class[0]).newInstance(new Object[0]);
                        HyperGraphPeer.this.peerInterface.setThisPeer(HyperGraphPeer.this);
                        Map interfaceConfig = (Map)Structs.getPart(HyperGraphPeer.this.configuration, "interfaceConfig");
                        if (interfaceConfig == null) {
                            throw new RuntimeException("Missing interfaceConfig configuration parameter.");
                        }
                        HyperGraphPeer.this.peerInterface.configure(interfaceConfig);
                        status = true;
                        boolean managePresence = false;
                        List bootstrapOperations = Structs.getOptPart(HyperGraphPeer.this.configuration, null, "bootstrap");
                        if (bootstrapOperations != null) {
                            for (Object x : bootstrapOperations) {
                                String classname = (String)Structs.getPart(x, "class");
                                if (AffirmIdentityBootstrap.class.getName().equals(classname)) {
                                    managePresence = true;
                                }
                                if (classname == null) {
                                    throw new RuntimeException("No 'class' specified in bootstrap operation.");
                                }
                                HashMap<String, Object> config = (HashMap<String, Object>)Structs.getPart(x, "config");
                                if (config == null) {
                                    config = new HashMap<String, Object>();
                                }
                                BootstrapPeer boot = (BootstrapPeer)Thread.currentThread().getContextClassLoader().loadClass(classname).newInstance();
                                boot.bootstrap(HyperGraphPeer.this, config);
                            }
                        }
                        if (managePresence) {
                            HyperGraphPeer.this.peerInterface.addPeerPresenceListener(new NetworkPeerPresenceListener(){

                                @Override
                                public void peerJoined(Object target) {
                                    if (HyperGraphPeer.this.getIdentity(target) != null) {
                                        return;
                                    }
                                    AffirmIdentity task = new AffirmIdentity(HyperGraphPeer.this, target);
                                    HyperGraphPeer.this.activityManager.initiateActivity(task);
                                }

                                @Override
                                public void peerLeft(Object target) {
                                    HyperGraphPeer.this.unbindNetworkTargetFromIdentity(target);
                                }
                            });
                        }
                        HyperGraphPeer.this.activityManager.start();
                        HyperGraphPeer.this.peerInterface.setMessageHandler(HyperGraphPeer.this.activityManager);
                        HyperGraphPeer.this.peerInterface.start();
                        if (HyperGraphPeer.this.tempGraph != null) {
                            HyperGraphPeer.this.log = new Log(HyperGraphPeer.this.tempGraph, HyperGraphPeer.this.peerInterface);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace(System.err);
                        HGUtils.throwRuntimeException(ex);
                    }
                } else {
                    System.out.println("Can not start HGBD: configuration not loaded");
                }
                return status;
            }
        });
    }

    public void stop() {
        this.activityManager.stop();
        if (this.peerInterface != null) {
            this.peerInterface.stop();
        }
        this.executorService.shutdownNow();
        this.activityManager.clear();
        this.peerIdentities.clear();
        if (this.tempGraph != null) {
            this.tempGraph.close();
        }
    }

    public StorageGraph getSubgraph(HGHandle handle) {
        HGPersistentHandle pHandle = this.graph.getPersistentHandle(handle);
        if (this.graph.getStore().containsLink(pHandle)) {
            return new HGStoreSubgraph(pHandle, this.graph.getStore());
        }
        return null;
    }

    public void updateNetworkProperties() {
        GetInterestsTask task = new GetInterestsTask(this);
        ActivityResult result = null;
        try {
            result = this.activityManager.initiateActivity(task).get();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        if (result.getException() != null) {
            HGUtils.throwRuntimeException(result.getException());
        }
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public HyperGraph getGraph() {
        return this.graph;
    }

    public Set<HGPeerIdentity> getConnectedPeers() {
        return this.peerIdentities.getYSet();
    }

    public HyperGraph getTempDb() {
        return this.tempGraph;
    }

    public ActivityManager getActivityManager() {
        return this.activityManager;
    }

    public PeerInterface getPeerInterface() {
        return this.peerInterface;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HGPeerIdentity getIdentity(Object networkTarget) {
        TwoWayMap<Object, HGPeerIdentity> twoWayMap = this.peerIdentities;
        synchronized (twoWayMap) {
            return this.peerIdentities.getY(networkTarget);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNetworkTarget(HGPeerIdentity id) {
        TwoWayMap<Object, HGPeerIdentity> twoWayMap = this.peerIdentities;
        synchronized (twoWayMap) {
            return this.peerIdentities.getX(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindIdentityToNetworkTarget(HGPeerIdentity id, Object networkTarget) {
        TwoWayMap<Object, HGPeerIdentity> twoWayMap = this.peerIdentities;
        synchronized (twoWayMap) {
            HGPeerIdentity oldId = this.peerIdentities.getY(networkTarget);
            if (oldId != null && oldId.equals(id)) {
                return;
            }
            this.peerIdentities.add(networkTarget, id);
            this.graph.define(id.getId(), id);
            for (PeerPresenceListener listener : this.peerListeners) {
                listener.peerJoined(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindNetworkTargetFromIdentity(Object networkTarget) {
        TwoWayMap<Object, HGPeerIdentity> twoWayMap = this.peerIdentities;
        synchronized (twoWayMap) {
            HGPeerIdentity id = this.peerIdentities.getY(networkTarget);
            if (id == null) {
                return;
            }
            this.peerIdentities.removeX(networkTarget);
            for (PeerPresenceListener listener : this.peerListeners) {
                listener.peerLeft(id);
            }
        }
    }

    public Map<String, Object> getObjectContext() {
        return this.context;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public void addPeerPresenceListener(PeerPresenceListener listener) {
        this.peerListeners.add(listener);
    }

    public void removePeerPresenceListener(PeerPresenceListener listener) {
        this.peerListeners.remove(listener);
    }
}

