/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.indexing;

import java.util.Comparator;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGLink;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.indexing.HGKeyIndexer;
import org.hypergraphdb.storage.BAtoBA;
import org.hypergraphdb.storage.ByteArrayConverter;

public class LinkIndexer
extends HGKeyIndexer {
    public LinkIndexer() {
    }

    public LinkIndexer(HGHandle type) {
        super(type);
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof LinkIndexer)) {
            return false;
        }
        LinkIndexer idx = (LinkIndexer)other;
        return this.getType().equals(idx.getType());
    }

    @Override
    public int hashCode() {
        return this.getType().hashCode();
    }

    @Override
    public Comparator<?> getComparator(HyperGraph graph) {
        return null;
    }

    @Override
    public ByteArrayConverter<?> getConverter(HyperGraph graph) {
        return BAtoBA.getInstance();
    }

    @Override
    public Object getKey(HyperGraph graph, Object atom) {
        HGLink link = (HGLink)atom;
        byte[] result = new byte[16 * link.getArity()];
        for (int i = 0; i < link.getArity(); ++i) {
            byte[] src = graph.getPersistentHandle(link.getTargetAt(i)).toByteArray();
            System.arraycopy(src, 0, result, i * 16, 16);
        }
        return result;
    }
}

