/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.handle;

import java.lang.ref.ReferenceQueue;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.handle.HGManagedLiveHandle;
import org.hypergraphdb.handle.WeakHandle;

public class WeakManagedHandle
extends WeakHandle
implements HGManagedLiveHandle {
    private long retrievalCount;
    private long lastAccessTime;

    public WeakManagedHandle(Object ref, HGPersistentHandle persistentHandle, byte flags, ReferenceQueue<Object> refQueue, long retrievalCount, long lastAccessTime) {
        super(ref, persistentHandle, flags, refQueue);
        this.retrievalCount = retrievalCount;
        this.lastAccessTime = lastAccessTime;
    }

    @Override
    public void accessed() {
        this.lastAccessTime = System.currentTimeMillis();
        ++this.retrievalCount;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public long getRetrievalCount() {
        return this.retrievalCount;
    }
}

