/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.handle;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.handle.HGLiveHandle;

public class WeakHandle
extends WeakReference<Object>
implements HGLiveHandle,
Comparable<HGHandle> {
    public static ThreadLocal<Boolean> returnEnqueued = new ThreadLocal();
    private HGPersistentHandle persistentHandle;
    private byte flags;

    public WeakHandle(Object ref, HGPersistentHandle persistentHandle, byte flags, ReferenceQueue<Object> refQueue) {
        super(ref, refQueue);
        this.persistentHandle = persistentHandle;
        this.flags = flags;
    }

    @Override
    public byte getFlags() {
        return this.flags;
    }

    @Override
    public HGPersistentHandle getPersistentHandle() {
        return this.persistentHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getRef() {
        Object x = this.get();
        if (this.isEnqueued()) {
            Boolean f = returnEnqueued.get();
            if (f != null && f.booleanValue()) {
                return x;
            }
            x = null;
            do {
                try {
                    WeakHandle weakHandle = this;
                    synchronized (weakHandle) {
                        this.wait(100L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.isEnqueued());
        }
        return x;
    }

    public void accessed() {
    }

    public final int hashCode() {
        return this.persistentHandle.hashCode();
    }

    public final boolean equals(Object other) {
        if (other == null || !(other instanceof HGHandle)) {
            return false;
        }
        if (other instanceof HGLiveHandle) {
            return this.persistentHandle.equals(((HGLiveHandle)other).getPersistentHandle());
        }
        return this.persistentHandle.equals((HGPersistentHandle)other);
    }

    public String toString() {
        return "phantomHandle(" + this.persistentHandle.toString() + ")";
    }

    @Override
    public int compareTo(HGHandle h) {
        if (h instanceof HGPersistentHandle) {
            return this.persistentHandle.compareTo((HGPersistentHandle)h);
        }
        return this.persistentHandle.compareTo(((HGLiveHandle)h).getPersistentHandle());
    }
}

