/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.handle;

import java.security.SecureRandom;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.handle.HGLiveHandle;
import org.hypergraphdb.handle.UUID;

public final class UUIDPersistentHandle
implements HGPersistentHandle {
    static final long serialVersionUID = -1L;
    static final SecureRandom rndGenerator = new SecureRandom();
    private UUID uuid;
    public static final int SIZE = 16;
    public static final UUIDPersistentHandle UUID_NULL_HANDLE = new UUIDPersistentHandle(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 0);

    public UUIDPersistentHandle() {
        byte[] rnd = new byte[16];
        rndGenerator.nextBytes(rnd);
        this.uuid = new UUID(4, rnd);
    }

    private UUIDPersistentHandle(UUID uuid) {
        this.uuid = uuid;
    }

    private UUIDPersistentHandle(byte[] value, int offset) {
        if (value == null) {
            throw new IllegalArgumentException("Attempt to construct UUIDPersistentHandle with a null value.");
        }
        if (value.length - offset < 16) {
            throw new IllegalArgumentException("Attempt to construct UUIDPersistentHandle with wrong size byte array.");
        }
        this.uuid = new UUID(value, offset);
    }

    public static UUIDPersistentHandle nullHandle() {
        return UUID_NULL_HANDLE;
    }

    public static UUIDPersistentHandle makeHandle() {
        return new UUIDPersistentHandle();
    }

    public static UUIDPersistentHandle makeHandle(byte[] value) {
        return new UUIDPersistentHandle(value, 0);
    }

    public static UUIDPersistentHandle makeHandle(byte[] value, int offset) {
        return new UUIDPersistentHandle(value, offset);
    }

    public static UUIDPersistentHandle makeHandle(String value) {
        return new UUIDPersistentHandle(new UUID(value));
    }

    @Override
    public byte[] toByteArray() {
        return this.uuid.mId;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof UUIDPersistentHandle) {
            return this.uuid.equals(((UUIDPersistentHandle)other).uuid);
        }
        if (other instanceof HGLiveHandle) {
            return ((HGLiveHandle)other).getPersistentHandle().equals(this);
        }
        return false;
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public String toString() {
        return this.uuid.toString();
    }

    @Override
    public int compareTo(HGHandle other) {
        if (other instanceof HGLiveHandle) {
            other = ((HGLiveHandle)other).getPersistentHandle();
        }
        return this.uuid.compareTo(((UUIDPersistentHandle)other).uuid);
    }

    @Override
    public int compareTo(HGPersistentHandle other) {
        return this.uuid.compareTo(((UUIDPersistentHandle)other).uuid);
    }
}

