/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.cache;

import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hypergraphdb.HGAtomAttrib;
import org.hypergraphdb.HGAtomCache;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.IncidenceSet;
import org.hypergraphdb.cache.CacheMap;
import org.hypergraphdb.cache.ColdAtoms;
import org.hypergraphdb.cache.HGCache;
import org.hypergraphdb.cache.HashCacheMap;
import org.hypergraphdb.handle.DefaultManagedLiveHandle;
import org.hypergraphdb.handle.HGLiveHandle;
import org.hypergraphdb.handle.WeakHandle;
import org.hypergraphdb.handle.WeakManagedHandle;
import org.hypergraphdb.transaction.HGTransactionConfig;
import org.hypergraphdb.transaction.TxCacheMap;
import org.hypergraphdb.transaction.TxMap;
import org.hypergraphdb.transaction.VBoxBody;
import org.hypergraphdb.util.CloseMe;
import org.hypergraphdb.util.WeakIdentityHashMap;

public class WeakRefAtomCache
implements HGAtomCache {
    private HyperGraph graph = null;
    private HGCache<HGPersistentHandle, IncidenceSet> incidenceCache = null;
    private CacheMap<HGPersistentHandle, WeakHandle> liveHandles = null;
    private TxCacheMap<HGPersistentHandle, WeakHandle> liveHandlesTx = null;
    private CacheMap<Object, HGLiveHandle> atoms = null;
    private TxCacheMap<Object, HGLiveHandle> atomsTx = null;
    private Map<HGLiveHandle, Object> frozenAtoms = null;
    private ColdAtoms coldAtoms = new ColdAtoms();
    public static final long DEFAULT_PHANTOM_QUEUE_POLL_INTERVAL = 500L;
    private ReadWriteLock gcLock = new ReentrantReadWriteLock();
    private ReferenceQueue<Object> refQueue = new ReferenceQueue();
    private PhantomCleanup cleanupThread = new PhantomCleanup();
    private HGTransactionConfig cleanupTxConfig = new HGTransactionConfig();
    private long phantomQueuePollInterval = 500L;
    private boolean closing = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRefQueue() throws InterruptedException {
        WeakHandle ref = (WeakHandle)this.refQueue.remove(this.phantomQueuePollInterval);
        while (ref != null) {
            this.liveHandles.drop(ref.getPersistentHandle());
            ref.clear();
            WeakHandle weakHandle = ref;
            synchronized (weakHandle) {
                ref.notifyAll();
            }
            ref = (WeakHandle)this.refQueue.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRefQueueTx() throws InterruptedException {
        WeakHandle.returnEnqueued.set(Boolean.TRUE);
        WeakHandle ref = (WeakHandle)this.refQueue.remove(this.phantomQueuePollInterval);
        while (ref != null) {
            HGPersistentHandle h = ref.getPersistentHandle();
            this.gcLock.writeLock().lock();
            try {
                TxCacheMap.Box theBox = this.liveHandlesTx.boxOf(h);
                if (theBox == null) continue;
                boolean keep = false;
                VBoxBody<Object> body = theBox.getBody();
                while (body != null && !keep) {
                    TxCacheMap.Box bb;
                    if (body.value != null && (bb = this.atomsTx.boxOf(((WeakHandle)body.value).getRef())) != null) {
                        keep = true;
                    }
                    body = body.next;
                }
                if (keep) continue;
                this.liveHandles.drop(h);
            }
            finally {
                this.gcLock.writeLock().unlock();
                ref.clear();
                WeakHandle weakHandle = ref;
                synchronized (weakHandle) {
                    ref.notifyAll();
                }
                ref = (WeakHandle)this.refQueue.poll();
            }
        }
        WeakHandle.returnEnqueued.set(Boolean.FALSE);
    }

    public WeakRefAtomCache(HyperGraph graph) {
        this.graph = graph;
        if (graph.getConfig().isTransactional()) {
            this.atomsTx = new TxCacheMap<Object, HGLiveHandle>(graph.getTransactionManager(), WeakIdentityHashMap.class);
            this.atoms = this.atomsTx;
            this.liveHandlesTx = new TxCacheMap<HGPersistentHandle, WeakHandle>(graph.getTransactionManager(), HashMap.class);
            this.liveHandles = this.liveHandlesTx;
            this.frozenAtoms = new TxMap<HGLiveHandle, Object>(graph.getTransactionManager(), null);
        } else {
            this.atoms = new HashCacheMap<Object, HGLiveHandle>();
            this.liveHandles = new HashCacheMap<HGPersistentHandle, WeakHandle>();
            this.frozenAtoms = new HashMap<HGLiveHandle, Object>();
        }
        this.cleanupThread.setPriority(10);
        this.cleanupThread.setDaemon(true);
        this.cleanupThread.start();
    }

    @Override
    public void setIncidenceCache(HGCache<HGPersistentHandle, IncidenceSet> cache) {
        this.incidenceCache = cache;
    }

    @Override
    public HGCache<HGPersistentHandle, IncidenceSet> getIncidenceCache() {
        return this.incidenceCache;
    }

    @Override
    public void setHyperGraph(HyperGraph hg2) {
        this.graph = hg2;
        this.cleanupThread.setName("HGCACHE Cleanup - " + this.graph.getLocation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HGLiveHandle atomAdded(HGPersistentHandle pHandle, Object atom, HGAtomAttrib attrib) {
        if (this.closing) {
            TempLiveHandle result = new TempLiveHandle(atom, pHandle, attrib.getFlags());
            this.atoms.put(atom, result);
            return result;
        }
        WeakHandle h = null;
        h = this.liveHandles.get(pHandle);
        if (h != null) {
            return h;
        }
        h = attrib != null && (attrib.getFlags() & 2) != 0 ? new WeakManagedHandle(atom, pHandle, attrib.getFlags(), this.refQueue, attrib.getRetrievalCount(), attrib.getLastAccessTime()) : new WeakHandle(atom, pHandle, attrib == null ? (byte)0 : attrib.getFlags(), this.refQueue);
        this.gcLock.readLock().lock();
        try {
            this.atoms.put(atom, h);
            this.liveHandles.put(pHandle, h);
            this.coldAtoms.add(atom);
            WeakHandle weakHandle = h;
            return weakHandle;
        }
        finally {
            this.gcLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HGLiveHandle atomRead(HGPersistentHandle pHandle, Object atom, HGAtomAttrib attrib) {
        if (this.closing) {
            TempLiveHandle result = new TempLiveHandle(atom, pHandle, attrib.getFlags());
            this.atoms.put(atom, result);
            return result;
        }
        WeakHandle h = null;
        h = this.liveHandles.get(pHandle);
        if (h != null) {
            return h;
        }
        h = attrib != null && (attrib.getFlags() & 2) != 0 ? new WeakManagedHandle(atom, pHandle, attrib.getFlags(), this.refQueue, attrib.getRetrievalCount(), attrib.getLastAccessTime()) : new WeakHandle(atom, pHandle, attrib == null ? (byte)0 : attrib.getFlags(), this.refQueue);
        this.gcLock.readLock().lock();
        try {
            this.atoms.load(atom, h);
            this.liveHandles.load(pHandle, h);
            this.coldAtoms.add(atom);
            WeakHandle weakHandle = h;
            return weakHandle;
        }
        finally {
            this.gcLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HGLiveHandle atomRefresh(HGLiveHandle handle, Object atom, boolean replace) {
        if (handle.getRef() == atom) {
            return handle;
        }
        if (this.closing) {
            if (handle instanceof WeakHandle) {
                ((WeakHandle)handle).clear();
            } else {
                ((TempLiveHandle)handle).setRef(atom);
            }
            return handle;
        }
        WeakHandle newLive = null;
        newLive = handle instanceof WeakManagedHandle ? new WeakManagedHandle(atom, handle.getPersistentHandle(), handle.getFlags(), this.refQueue, ((WeakManagedHandle)handle).getRetrievalCount(), ((WeakManagedHandle)handle).getRetrievalCount()) : new WeakHandle(atom, handle.getPersistentHandle(), handle.getFlags(), this.refQueue);
        Object curr = handle.getRef();
        ((WeakHandle)handle).clear();
        this.gcLock.readLock().lock();
        try {
            if (replace || curr != null) {
                if (curr != null) {
                    this.atoms.remove(curr);
                }
                this.atoms.put(atom, newLive);
                this.liveHandles.put(handle.getPersistentHandle(), newLive);
            } else {
                this.atoms.load(atom, newLive);
                this.liveHandles.load(handle.getPersistentHandle(), newLive);
            }
            this.coldAtoms.add(atom);
            WeakHandle weakHandle = newLive;
            return weakHandle;
        }
        finally {
            this.gcLock.readLock().unlock();
        }
    }

    @Override
    public void close() {
        this.closing = true;
        this.cleanupThread.end();
        while (this.cleanupThread.isAlive()) {
            try {
                this.cleanupThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.frozenAtoms.clear();
        this.incidenceCache.clear();
        if (this.incidenceCache instanceof CloseMe) {
            ((CloseMe)((Object)this.incidenceCache)).close();
        }
        this.atoms.clear();
        this.liveHandles.clear();
    }

    @Override
    public HGLiveHandle get(HGPersistentHandle pHandle) {
        WeakHandle h = this.liveHandles.get(pHandle);
        if (h != null) {
            h.accessed();
        }
        return h;
    }

    @Override
    public HGLiveHandle get(Object atom) {
        return this.atoms.get(atom);
    }

    @Override
    public void remove(HGLiveHandle handle) {
        this.atoms.remove(handle.getRef());
        this.liveHandles.remove(handle.getPersistentHandle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFrozen(HGLiveHandle handle) {
        Map<HGLiveHandle, Object> map = this.frozenAtoms;
        synchronized (map) {
            return this.frozenAtoms.containsKey(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeze(HGLiveHandle handle) {
        Object atom = handle.getRef();
        if (atom != null) {
            Map<HGLiveHandle, Object> map = this.frozenAtoms;
            synchronized (map) {
                this.frozenAtoms.put(handle, atom);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unfreeze(HGLiveHandle handle) {
        Map<HGLiveHandle, Object> map = this.frozenAtoms;
        synchronized (map) {
            this.frozenAtoms.remove(handle);
        }
    }

    public void printSizes() {
        System.out.println("atoms map: " + this.atomsTx.mapSize());
        System.out.println("liveHandles map: " + this.liveHandlesTx.mapSize());
        System.out.println("cold atoms: " + this.coldAtoms.size());
        System.out.println("frozen atoms: " + this.frozenAtoms.size());
    }

    private class PhantomCleanup
    extends Thread {
        private volatile boolean done;

        private PhantomCleanup() {
        }

        @Override
        public void run() {
            WeakRefAtomCache.this.cleanupTxConfig.setNoStorage(true);
            this.done = false;
            while (!this.done) {
                try {
                    if (WeakRefAtomCache.this.graph.getConfig().isTransactional()) {
                        WeakRefAtomCache.this.processRefQueueTx();
                        continue;
                    }
                    WeakRefAtomCache.this.processRefQueue();
                }
                catch (InterruptedException exc) {
                    Thread.currentThread().interrupt();
                }
                catch (Throwable t) {
                    System.err.println("PhantomCleanup thread caught an unexpected exception, stack trace follows:");
                    t.printStackTrace(System.err);
                }
            }
        }

        public void end() {
            this.done = true;
        }
    }

    private static class TempLiveHandle
    extends DefaultManagedLiveHandle {
        public TempLiveHandle(Object ref, HGPersistentHandle persistentHandle, byte flags) {
            super(ref, persistentHandle, flags, 0L, 0L);
        }

        public void setRef(Object ref) {
            this.ref = ref;
        }
    }
}

