/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.cache;

import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hypergraphdb.HGAtomAttrib;
import org.hypergraphdb.HGAtomCache;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.IncidenceSet;
import org.hypergraphdb.cache.ColdAtoms;
import org.hypergraphdb.cache.HGCache;
import org.hypergraphdb.event.HGAtomEvictEvent;
import org.hypergraphdb.handle.DefaultManagedLiveHandle;
import org.hypergraphdb.handle.HGLiveHandle;
import org.hypergraphdb.handle.PhantomHandle;
import org.hypergraphdb.handle.PhantomManagedHandle;
import org.hypergraphdb.util.CloseMe;
import org.hypergraphdb.util.WeakIdentityHashMap;

public class PhantomRefAtomCache
implements HGAtomCache {
    private HyperGraph graph = null;
    private HGCache<HGPersistentHandle, IncidenceSet> incidenceCache = null;
    private final Map<HGPersistentHandle, PhantomHandle> liveHandles = new HashMap<HGPersistentHandle, PhantomHandle>();
    private Map<Object, HGLiveHandle> atoms = new WeakIdentityHashMap<Object, HGLiveHandle>();
    private Map<HGLiveHandle, Object> frozenAtoms = new IdentityHashMap<HGLiveHandle, Object>();
    private ColdAtoms coldAtoms = new ColdAtoms();
    public static final long DEFAULT_PHANTOM_QUEUE_POLL_INTERVAL = 500L;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private ReferenceQueue refQueue = new ReferenceQueue();
    private PhantomCleanup phantomCleanupThread = new PhantomCleanup();
    private long phantomQueuePollInterval = 500L;
    private boolean closing = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRefQueue() throws InterruptedException {
        PhantomHandle ref = (PhantomHandle)this.refQueue.remove(this.phantomQueuePollInterval);
        while (ref != null) {
            this.graph.getEventManager().dispatch(this.graph, new HGAtomEvictEvent(ref, ref.fetchRef()));
            this.lock.writeLock().lock();
            try {
                this.liveHandles.remove(ref.getPersistentHandle());
            }
            finally {
                this.lock.writeLock().unlock();
            }
            ref.clear();
            PhantomHandle phantomHandle = ref;
            synchronized (phantomHandle) {
                ref.notifyAll();
            }
            ref = (PhantomHandle)this.refQueue.poll();
        }
    }

    public PhantomRefAtomCache() {
        this.phantomCleanupThread.setPriority(10);
        this.phantomCleanupThread.setDaemon(true);
        this.phantomCleanupThread.start();
    }

    @Override
    public void setIncidenceCache(HGCache<HGPersistentHandle, IncidenceSet> cache) {
        this.incidenceCache = cache;
    }

    @Override
    public HGCache<HGPersistentHandle, IncidenceSet> getIncidenceCache() {
        return this.incidenceCache;
    }

    @Override
    public void setHyperGraph(HyperGraph hg2) {
        this.graph = hg2;
        this.phantomCleanupThread.setName("HGCACHE Cleanup - " + this.graph.getLocation());
    }

    @Override
    public HGLiveHandle atomAdded(HGPersistentHandle pHandle, Object atom, HGAtomAttrib attrib) {
        return this.atomRead(pHandle, atom, attrib);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HGLiveHandle atomRead(HGPersistentHandle pHandle, Object atom, HGAtomAttrib attrib) {
        if (this.closing) {
            TempLiveHandle result = new TempLiveHandle(atom, pHandle, attrib.getFlags());
            this.atoms.put(atom, result);
            return result;
        }
        this.lock.writeLock().lock();
        PhantomHandle h = null;
        try {
            h = this.liveHandles.get(pHandle);
            if (h != null) {
                PhantomHandle phantomHandle = h;
                return phantomHandle;
            }
            h = (attrib.getFlags() & 2) == 0 ? new PhantomHandle(atom, pHandle, attrib.getFlags(), this.refQueue) : new PhantomManagedHandle(atom, pHandle, attrib.getFlags(), this.refQueue, attrib.getRetrievalCount(), attrib.getLastAccessTime());
            this.atoms.put(atom, h);
            this.liveHandles.put(pHandle, h);
            this.coldAtoms.add(atom);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HGLiveHandle atomRefresh(HGLiveHandle handle, Object atom, boolean replace) {
        if (this.closing) {
            if (handle instanceof PhantomHandle) {
                ((PhantomHandle)handle).storeRef(atom);
            } else {
                ((TempLiveHandle)handle).setRef(atom);
            }
            return handle;
        }
        if (handle == null) {
            throw new NullPointerException("atomRefresh: handle is null.");
        }
        this.lock.writeLock().lock();
        try {
            PhantomHandle ph = (PhantomHandle)handle;
            PhantomHandle existing = this.liveHandles.get(ph.getPersistentHandle());
            if (existing != ph) {
                if (existing != null) {
                    this.liveHandles.remove(existing.getPersistentHandle());
                    this.atoms.remove(existing.getRef());
                }
                ph.storeRef(atom);
                this.liveHandles.put(ph.getPersistentHandle(), ph);
                this.atoms.put(atom, ph);
                this.coldAtoms.add(atom);
            } else if (ph.getRef() != atom) {
                this.atoms.remove(ph.getRef());
                ph.storeRef(atom);
                this.atoms.put(atom, ph);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return handle;
    }

    @Override
    public void close() {
        this.closing = true;
        this.phantomCleanupThread.end();
        while (this.phantomCleanupThread.isAlive()) {
            try {
                this.phantomCleanupThread.join();
            }
            catch (InterruptedException ex) {}
        }
        PhantomHandle.returnEnqueued.set(Boolean.TRUE);
        try {
            this.processRefQueue();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        Iterator<Map.Entry<HGPersistentHandle, PhantomHandle>> i = this.liveHandles.entrySet().iterator();
        while (i.hasNext()) {
            PhantomHandle h = i.next().getValue();
            Object x = h.fetchRef();
            this.graph.getEventManager().dispatch(this.graph, new HGAtomEvictEvent(h, x));
            if (!h.isEnqueued()) continue;
            h.clear();
        }
        PhantomHandle.returnEnqueued.set(Boolean.FALSE);
        this.frozenAtoms.clear();
        this.incidenceCache.clear();
        if (this.incidenceCache instanceof CloseMe) {
            ((CloseMe)((Object)this.incidenceCache)).close();
        }
        this.atoms.clear();
        this.liveHandles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HGLiveHandle get(HGPersistentHandle pHandle) {
        this.lock.readLock().lock();
        try {
            PhantomHandle h = this.liveHandles.get(pHandle);
            if (h != null) {
                h.accessed();
            }
            PhantomHandle phantomHandle = h;
            return phantomHandle;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HGLiveHandle get(Object atom) {
        this.lock.readLock().lock();
        try {
            HGLiveHandle hGLiveHandle = this.atoms.get(atom);
            return hGLiveHandle;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(HGLiveHandle handle) {
        this.lock.writeLock().lock();
        try {
            this.atoms.remove(handle.getRef());
            if (handle instanceof PhantomHandle) {
                ((PhantomHandle)handle).storeRef(null);
            }
            this.liveHandles.remove(handle.getPersistentHandle());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFrozen(HGLiveHandle handle) {
        Map<HGLiveHandle, Object> map = this.frozenAtoms;
        synchronized (map) {
            return this.frozenAtoms.containsKey(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeze(HGLiveHandle handle) {
        Object atom = handle.getRef();
        if (atom != null) {
            Map<HGLiveHandle, Object> map = this.frozenAtoms;
            synchronized (map) {
                this.frozenAtoms.put(handle, atom);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unfreeze(HGLiveHandle handle) {
        Map<HGLiveHandle, Object> map = this.frozenAtoms;
        synchronized (map) {
            this.frozenAtoms.remove(handle);
        }
    }

    private class PhantomCleanup
    extends Thread {
        private boolean done;

        private PhantomCleanup() {
        }

        @Override
        public void run() {
            PhantomHandle.returnEnqueued.set(Boolean.TRUE);
            this.done = false;
            while (!this.done) {
                try {
                    PhantomRefAtomCache.this.processRefQueue();
                }
                catch (InterruptedException exc) {
                    Thread.currentThread().interrupt();
                }
                catch (Throwable t) {
                    System.err.println("PhantomCleanup thread caught an unexpected exception, stack trace follows:");
                    t.printStackTrace(System.err);
                }
            }
            PhantomHandle.returnEnqueued.set(Boolean.FALSE);
        }

        public void end() {
            this.done = true;
        }
    }

    private static class TempLiveHandle
    extends DefaultManagedLiveHandle {
        public TempLiveHandle(Object ref, HGPersistentHandle persistentHandle, byte flags) {
            super(ref, persistentHandle, flags, 0L, 0L);
        }

        public void setRef(Object ref) {
            this.ref = ref;
        }
    }
}

