/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hypergraphdb.HGEnvironment;
import org.hypergraphdb.cache.CacheActionQueueSingleton;
import org.hypergraphdb.cache.HGCache;
import org.hypergraphdb.util.ActionQueueThread;
import org.hypergraphdb.util.CloseMe;
import org.hypergraphdb.util.MemoryWarningSystem;
import org.hypergraphdb.util.RefResolver;

public class MRUCache<Key, Value>
implements HGCache<Key, Value>,
CloseMe {
    private RefResolver<Key, Value> resolver;
    int maxSize = -1;
    float usedMemoryThreshold;
    float evictPercent;
    private ReadWriteLock lock = null;
    private Entry<Key, Value> top = null;
    private Entry<Key, Value> cutoffTail = null;
    private int cutoffSize = 0;
    private Map<Key, Entry<Key, Value>> map = new HashMap<Key, Entry<Key, Value>>();
    private MemoryWarningSystem.Listener memListener = new MemoryWarningSystem.Listener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void memoryUsageLow(long usedMemory, long maxMemory) {
            CacheActionQueueSingleton.get().pauseActions();
            try {
                new EvictAction().run();
            }
            finally {
                CacheActionQueueSingleton.get().resumeActions();
            }
        }
    };

    void unlink(Entry<Key, Value> e) {
        if (e.prev != null) {
            e.prev.next = e.next;
        }
        if (e.next != null) {
            e.next.prev = e.prev;
        }
        e.next = null;
        e.prev = null;
    }

    private void adjustCutoffTail() {
        if (this.cutoffTail == null) {
            this.cutoffTail = this.top;
            this.cutoffSize = this.map.size();
        }
        double desired = (float)this.map.size() * this.evictPercent;
        while ((double)this.cutoffSize > desired && this.cutoffTail.next != null) {
            this.cutoffTail = this.cutoffTail.next;
            --this.cutoffSize;
        }
        while ((double)this.cutoffSize < desired && this.cutoffTail.prev != null) {
            this.cutoffTail = this.cutoffTail.prev;
            ++this.cutoffSize;
        }
    }

    private void initMemoryListener() {
        HGEnvironment.getMemoryWarningSystem().addListener(this.memListener);
    }

    protected void finalize() {
        this.close();
    }

    public MRUCache() {
        this.initMemoryListener();
        this.lock = new ReentrantReadWriteLock();
    }

    public MRUCache(ReadWriteLock lockImplementation) {
        this.lock = lockImplementation;
    }

    public MRUCache(int maxSize, int evictCount) {
        this();
        this.maxSize = maxSize;
        if (maxSize <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        if (evictCount <= 0) {
            throw new IllegalArgumentException("evictCount <= 0");
        }
        this.evictPercent = (float)evictCount / (float)maxSize;
    }

    public MRUCache(float usedMemoryThreshold, float evictPercent) {
        this();
        if (usedMemoryThreshold <= 0.0f) {
            throw new IllegalArgumentException("usedMemoryThreshold <= 0");
        }
        this.usedMemoryThreshold = usedMemoryThreshold;
        if (evictPercent <= 0.0f) {
            throw new IllegalArgumentException("evictPercent <= 0");
        }
        this.evictPercent = evictPercent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value get(Key key) {
        Entry<Key, Value> e;
        this.lock.readLock().lock();
        try {
            e = this.map.get(key);
            if (e != null) {
                CacheActionQueueSingleton.get().addAction(new PutOnTop(e));
                Object Value = e.value;
                return Value;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            e = this.map.get(key);
            if (e == null) {
                Value v = this.resolver.resolve(key);
                e = new Entry<Key, Value>(key, v, null, null);
                this.map.put(key, e);
                CacheActionQueueSingleton.get().addAction(new AddElement(e));
                Value Value = v;
                return Value;
            }
            Object Value = e.value;
            return Value;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value getIfLoaded(Key key) {
        this.lock.readLock().lock();
        try {
            Entry<Key, Value> e = this.map.get(key);
            if (e == null) {
                Value Value = null;
                return Value;
            }
            CacheActionQueueSingleton.get().addAction(new PutOnTop(e));
            Object Value = e.value;
            return Value;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean isLoaded(Key key) {
        this.lock.readLock().lock();
        boolean b = this.map.containsKey(key);
        this.lock.readLock().unlock();
        return b;
    }

    @Override
    public void remove(Key key) {
        this.lock.writeLock().lock();
        Entry<Key, Value> e = this.map.remove(key);
        this.lock.writeLock().unlock();
        if (e != null) {
            CacheActionQueueSingleton.get().addAction(new UnlinkEntry(e));
        }
    }

    @Override
    public RefResolver<Key, Value> getResolver() {
        return this.resolver;
    }

    @Override
    public void setResolver(RefResolver<Key, Value> resolver) {
        this.resolver = resolver;
    }

    @Override
    public void clear() {
        ActionQueueThread aq = CacheActionQueueSingleton.get();
        aq.addAction(new ClearAction());
        aq.completeAll();
    }

    public void clearNonBlocking() {
        CacheActionQueueSingleton.get().addAction(new ClearAction());
    }

    public void checkConsistent() {
    }

    public void setLockImplementation(ReadWriteLock lockImplementation) {
        this.lock = lockImplementation;
    }

    @Override
    public void close() {
        HGEnvironment.getMemoryWarningSystem().removeListener(this.memListener);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    class EvictAction
    implements Runnable {
        EvictAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (MRUCache.this.top == null) {
                return;
            }
            MRUCache.this.adjustCutoffTail();
            if (((MRUCache)MRUCache.this).cutoffTail.prev != null) {
                ((MRUCache)MRUCache.this).cutoffTail.prev.next = null;
            }
            while (MRUCache.this.cutoffTail != null) {
                MRUCache.this.lock.writeLock().lock();
                try {
                    MRUCache.this.map.remove(((MRUCache)MRUCache.this).cutoffTail.key);
                    MRUCache.this.cutoffTail = ((MRUCache)MRUCache.this).cutoffTail.next;
                }
                finally {
                    MRUCache.this.lock.writeLock().unlock();
                }
            }
        }
    }

    class AddElement
    implements Runnable {
        Entry<Key, Value> e;

        public AddElement(Entry<Key, Value> e) {
            this.e = e;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MRUCache.this.lock.readLock().lock();
            try {
                if (!MRUCache.this.map.containsKey(this.e.key)) {
                    return;
                }
                this.e.next = MRUCache.this.top;
                if (MRUCache.this.top != null) {
                    ((MRUCache)MRUCache.this).top.prev = this.e;
                }
                MRUCache.this.top = this.e;
            }
            finally {
                MRUCache.this.lock.readLock().unlock();
            }
            MRUCache.this.adjustCutoffTail();
        }
    }

    class UnlinkEntry
    implements Runnable {
        Entry<Key, Value> e;

        UnlinkEntry(Entry<Key, Value> e) {
            this.e = e;
        }

        @Override
        public void run() {
            MRUCache.this.unlink(this.e);
        }
    }

    class PutOnTop
    implements Runnable {
        Entry<Key, Value> l;

        PutOnTop(Entry<Key, Value> l) {
            this.l = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MRUCache.this.lock.readLock().lock();
            try {
                if (this.l.prev == null || !MRUCache.this.map.containsKey(this.l.key)) {
                    return;
                }
                if (this.l == MRUCache.this.cutoffTail) {
                    MRUCache.this.cutoffTail = this.l.prev;
                }
                this.l.prev.next = this.l.next;
                if (this.l.next != null) {
                    this.l.next.prev = this.l.prev;
                }
                this.l.next = MRUCache.this.top;
                this.l.prev = null;
                ((MRUCache)MRUCache.this).top.prev = this.l;
                MRUCache.this.top = this.l;
            }
            finally {
                MRUCache.this.lock.readLock().unlock();
            }
        }
    }

    class ClearAction
    implements Runnable {
        ClearAction() {
        }

        @Override
        public void run() {
            MRUCache.this.lock.writeLock().lock();
            MRUCache.this.map.clear();
            MRUCache.this.cutoffTail = (MRUCache.this.top = null);
            MRUCache.this.cutoffSize = 0;
            MRUCache.this.lock.writeLock().unlock();
        }
    }

    static class Entry<Key, Value> {
        Key key;
        Value value;
        Entry<Key, Value> next;
        Entry<Key, Value> prev;

        Entry(Key key, Value value, Entry<Key, Value> next, Entry<Key, Value> prev) {
            this.key = key;
            this.value = value;
            this.next = next;
            this.prev = prev;
        }
    }
}

