/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.cache;

import java.util.HashMap;
import org.hypergraphdb.HGAtomAttrib;
import org.hypergraphdb.HGAtomCache;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.IncidenceSet;
import org.hypergraphdb.cache.CacheActionQueueSingleton;
import org.hypergraphdb.cache.HGCache;
import org.hypergraphdb.event.HGAtomEvictEvent;
import org.hypergraphdb.handle.DefaultManagedLiveHandle;
import org.hypergraphdb.handle.HGLiveHandle;
import org.hypergraphdb.util.ActionQueueThread;

public final class DefaultAtomCache
implements HGAtomCache {
    private HyperGraph hg;
    private final HashMap<HGPersistentHandle, LiveHandle> liveHandles = new HashMap();
    private final HashMap<Object, LiveHandle> atoms = new HashMap();
    private HGCache<HGPersistentHandle, IncidenceSet> incidenceSets = null;
    private long retrievalCount = 0L;
    private long lastAccessTime = System.currentTimeMillis();
    private double retrievalFrequencyWeight = 10.0;
    private double lastAccessTimeWeight = 1.0;
    private LiveHandle atomQueueTail = null;
    private ActionQueueThread queueThread = CacheActionQueueSingleton.get();
    private long maxAtoms = 100L;
    private long maxIncidenceSets = 10L;

    public double importanceOf(LiveHandle cached) {
        return this.retrievalFrequencyWeight * ((double)cached.getRetrievalCount() / (double)this.retrievalCount) + this.lastAccessTimeWeight * ((double)cached.getLastAccessTime() / (double)this.lastAccessTime);
    }

    private void importanceUp(LiveHandle cached) {
        double importance = this.importanceOf(cached);
        while (cached.next != null && importance > this.importanceOf(cached.next)) {
            cached.next.prev = cached.prev;
            if (cached.prev != null) {
                cached.prev.next = cached.next;
            }
            cached.prev = cached.next;
            if (cached.next.next != null) {
                cached.next.next.prev = cached;
            }
            cached.next = cached.next.next;
            cached.prev.next = cached;
            if (this.atomQueueTail != cached) continue;
            this.atomQueueTail = cached.prev;
        }
    }

    private void insert(LiveHandle handle) {
        if ((long)this.liveHandles.size() >= this.maxAtoms) {
            this.queueThread.addAction(new AtomsEvictAction(this.liveHandles.size() / 10));
            this.queueThread.setPriority(7);
        }
        this.liveHandles.put(handle.getPersistentHandle(), handle);
        this.atoms.put(handle.getRef(), handle);
        this.queueThread.addAction(new AddAtomAction(handle));
    }

    @Override
    public void setIncidenceCache(HGCache<HGPersistentHandle, IncidenceSet> cache) {
        this.incidenceSets = cache;
    }

    @Override
    public HGCache<HGPersistentHandle, IncidenceSet> getIncidenceCache() {
        return this.incidenceSets;
    }

    public void setMaxAtoms(long maxAtoms) {
        this.maxAtoms = maxAtoms;
    }

    public long getMaxAtoms() {
        return this.maxAtoms;
    }

    public void setMaxIncidenceSets(long maxIncidenceSets) {
        this.maxIncidenceSets = maxIncidenceSets;
    }

    public long getMaxIncidenceSets() {
        return this.maxIncidenceSets;
    }

    @Override
    public void setHyperGraph(HyperGraph hg2) {
        this.hg = hg2;
    }

    @Override
    public void close() {
        for (HGLiveHandle hGLiveHandle : this.liveHandles.values()) {
            this.hg.getEventManager().dispatch(this.hg, new HGAtomEvictEvent(hGLiveHandle, hGLiveHandle.getRef()));
        }
        this.liveHandles.clear();
        this.atoms.clear();
        this.incidenceSets.clear();
        this.atomQueueTail = null;
        this.queueThread.stopRunning();
    }

    @Override
    public HGLiveHandle get(HGPersistentHandle pHandle) {
        LiveHandle result = this.liveHandles.get(pHandle);
        if (result == null) {
            return null;
        }
        result.accessed();
        ++this.retrievalCount;
        this.lastAccessTime = System.currentTimeMillis();
        this.queueThread.addAction(new AtomAccessedAction(result));
        return result;
    }

    @Override
    public HGLiveHandle get(Object atom) {
        LiveHandle result = this.atoms.get(atom);
        if (result == null) {
            return null;
        }
        result.accessed();
        ++this.retrievalCount;
        this.lastAccessTime = System.currentTimeMillis();
        this.queueThread.addAction(new AtomAccessedAction(result));
        return result;
    }

    @Override
    public HGLiveHandle atomAdded(HGPersistentHandle pHandle, Object atom, HGAtomAttrib attrib) {
        return this.atomRead(pHandle, atom, attrib);
    }

    @Override
    public HGLiveHandle atomRead(HGPersistentHandle pHandle, Object atom, HGAtomAttrib attrib) {
        LiveHandle lHandle = null;
        lHandle = (attrib.getFlags() & 2) != 0 ? new LiveHandle(atom, pHandle, attrib.getFlags(), attrib.getRetrievalCount(), attrib.getLastAccessTime()) : new LiveHandle(atom, pHandle, attrib.getFlags());
        this.insert(lHandle);
        return lHandle;
    }

    @Override
    public HGLiveHandle atomRefresh(HGLiveHandle handle, Object atom, boolean replace) {
        LiveHandle existing = this.liveHandles.get(handle.getPersistentHandle());
        if (existing != null) {
            this.atoms.remove(existing.getRef());
            existing.setRef(atom);
            this.atoms.put(atom, existing);
        } else {
            LiveHandle lHandle = (LiveHandle)handle;
            lHandle.setRef(atom);
            this.insert(lHandle);
        }
        return handle;
    }

    @Override
    public void freeze(HGLiveHandle handle) {
        this.queueThread.addAction(new AtomDetachAction((LiveHandle)handle));
    }

    @Override
    public void unfreeze(HGLiveHandle handle) {
        this.queueThread.addAction(new AddAtomAction((LiveHandle)handle));
    }

    @Override
    public boolean isFrozen(HGLiveHandle handle) {
        LiveHandle h = (LiveHandle)handle;
        return h.prev == null && h.next == null;
    }

    @Override
    public void remove(HGLiveHandle handle) {
        this.incidenceSets.remove(handle.getPersistentHandle());
        this.atoms.remove(handle.getRef());
        this.liveHandles.remove(handle.getPersistentHandle());
        this.queueThread.addAction(new AtomDetachAction((LiveHandle)handle));
        ((LiveHandle)handle).setRef(null);
    }

    private class AtomsEvictAction
    implements Runnable {
        long n;

        AtomsEvictAction(long n) {
            this.n = n;
        }

        @Override
        public void run() {
            if (DefaultAtomCache.this.atomQueueTail == null) {
                return;
            }
            LiveHandle newTail = DefaultAtomCache.this.atomQueueTail;
            while (this.n-- > 0L && newTail.next != null) {
                LiveHandle current = newTail;
                DefaultAtomCache.this.liveHandles.remove(newTail.getPersistentHandle());
                DefaultAtomCache.this.atoms.remove(newTail.getRef());
                DefaultAtomCache.this.hg.getEventManager().dispatch(DefaultAtomCache.this.hg, new HGAtomEvictEvent(newTail, newTail.getRef()));
                newTail.setRef(null);
                newTail = newTail.next;
                current.next = null;
                current.prev = null;
            }
            if (newTail.next == null) {
                DefaultAtomCache.this.liveHandles.remove(newTail.getPersistentHandle());
                DefaultAtomCache.this.atoms.remove(newTail.getRef());
                DefaultAtomCache.this.hg.getEventManager().dispatch(DefaultAtomCache.this.hg, new HGAtomEvictEvent(newTail, newTail.getRef()));
                newTail.setRef(null);
                newTail.next = null;
                newTail.prev = null;
                DefaultAtomCache.this.atomQueueTail = null;
            } else {
                newTail.prev = null;
                DefaultAtomCache.this.atomQueueTail = newTail;
            }
        }
    }

    private class AtomDetachAction
    implements Runnable {
        LiveHandle atom;

        public AtomDetachAction(LiveHandle atom) {
            this.atom = atom;
        }

        @Override
        public void run() {
            if (this.atom.prev != null) {
                this.atom.prev.next = this.atom.next;
            }
            if (this.atom.next != null) {
                this.atom.next.prev = this.atom.prev;
            }
            this.atom.next = null;
            this.atom.prev = null;
        }
    }

    private class AddAtomAction
    implements Runnable {
        LiveHandle atom;

        AddAtomAction(LiveHandle atom) {
            this.atom = atom;
        }

        @Override
        public void run() {
            if (DefaultAtomCache.this.atomQueueTail == null) {
                DefaultAtomCache.this.atomQueueTail = this.atom;
            } else {
                this.atom.next = DefaultAtomCache.this.atomQueueTail;
                ((DefaultAtomCache)DefaultAtomCache.this).atomQueueTail.prev = this.atom;
                DefaultAtomCache.this.atomQueueTail = this.atom;
                DefaultAtomCache.this.importanceUp(this.atom);
            }
        }
    }

    private class AtomAccessedAction
    implements Runnable {
        LiveHandle atom;

        AtomAccessedAction(LiveHandle atom) {
            this.atom = atom;
        }

        @Override
        public void run() {
            DefaultAtomCache.this.importanceUp(this.atom);
        }
    }

    private static class LiveHandle
    extends DefaultManagedLiveHandle {
        LiveHandle next;
        LiveHandle prev;

        public LiveHandle(Object ref, HGPersistentHandle pHandle, byte flags) {
            super(ref, pHandle, flags, 1L, System.currentTimeMillis());
        }

        public LiveHandle(Object ref, HGPersistentHandle pHandle, byte flags, long retrievalCount, long lastAccessTime) {
            super(ref, pHandle, flags, retrievalCount, System.currentTimeMillis());
        }

        void setRef(Object ref) {
            this.ref = ref;
        }
    }
}

