/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.atom.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Iterator;
import java.util.Stack;
import org.hypergraphdb.util.Pair;

public final class UUIDTrie {
    private static final leaf_trie THE_LEAF = new leaf_trie();
    private node_trie root = new node_trie();

    public void clear() {
        this.root = new node_trie();
    }

    public UUIDTrie clone() {
        UUIDTrie trie2 = new UUIDTrie();
        trie2.root = (node_trie)this.root.clone();
        return trie2;
    }

    public boolean add(byte[] uuid) {
        node_trie node = this.root;
        int offset = 0;
        while (true) {
            byte position;
            if (offset % 2 == 0) {
                position = (byte)(uuid[offset >> 1] >> 4);
                if (position < 0) {
                    position = (byte)(-position + 7);
                }
            } else {
                position = (byte)(uuid[offset >> 1] & 0xF);
            }
            if (node.children[position] == null) {
                node.count = (byte)(node.count + 1);
                if (offset == 31) {
                    node.children[position] = THE_LEAF;
                    return true;
                }
                node.children[position] = new node_trie();
                node = node.children[position];
                offset = (byte)(offset + 1);
                continue;
            }
            if (offset == 31) {
                return false;
            }
            node = (node_trie)node.children[position];
            offset = (byte)(offset + 1);
        }
    }

    public boolean find(byte[] uuid) {
        node_trie node = this.root;
        int offset = 0;
        while (true) {
            byte position;
            if (offset % 2 == 0) {
                position = (byte)(uuid[offset >> 1] >> 4);
                if (position < 0) {
                    position = (byte)(-position + 7);
                }
            } else {
                position = (byte)(uuid[offset >> 1] & 0xF);
            }
            if (offset == 31) {
                return node.children[position] != null;
            }
            node_trie child = (node_trie)node.children[position];
            if (child == null) {
                return false;
            }
            if (child.count == 0) {
                node.children[position] = null;
                node.count = (byte)(node.count - 1);
                return false;
            }
            node = child;
            offset = (byte)(offset + 1);
        }
    }

    public boolean remove(byte[] uuid) {
        node_trie node = this.root;
        int offset = 0;
        while (true) {
            byte position;
            if (offset % 2 == 0) {
                position = (byte)(uuid[offset >> 1] >> 4);
                if (position < 0) {
                    position = (byte)(-position + 7);
                }
            } else {
                position = (byte)(uuid[offset >> 1] & 0xF);
            }
            if (node.children[position] == null) {
                return false;
            }
            if (offset == 31) {
                node.children[position] = null;
                node.count = (byte)(node.count - 1);
                return true;
            }
            node = (node_trie)node.children[position];
            offset = (byte)(offset + 1);
        }
    }

    private void serialize(ByteArrayOutputStream out, node_trie node, int depth) {
        int i = 0;
        int layout = 0;
        int bit = 1;
        while (i < 8) {
            if (node.children[i] != null) {
                layout = (byte)(layout | bit);
            }
            i = (byte)(i + 1);
            bit *= 2;
        }
        out.write(layout);
        i = 8;
        layout = 0;
        bit = 1;
        while (i < 16) {
            if (node.children[i] != null) {
                layout = (byte)(layout | bit);
            }
            i = (byte)(i + 1);
            bit *= 2;
        }
        out.write(layout);
        if (depth < 31) {
            for (i = 0; i < 16; i = (int)((byte)(i + 1))) {
                if (node.children[i] == null) continue;
                this.serialize(out, (node_trie)node.children[i], depth + 1);
            }
        }
    }

    public byte[] serialize() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.serialize(out, this.root, 0);
        return out.toByteArray();
    }

    private void deserialize(ByteArrayInputStream in, node_trie node, int depth) {
        byte layout1 = (byte)in.read();
        byte layout2 = (byte)in.read();
        if (depth < 31) {
            node_trie child;
            int i = 0;
            byte bit = 1;
            while (i < 8) {
                if ((layout1 & bit) != 0) {
                    node.count = (byte)(node.count + 1);
                    child = new node_trie();
                    node.children[i] = child;
                    this.deserialize(in, child, depth + 1);
                }
                i = (byte)(i + 1);
                bit = (byte)(bit * 2);
            }
            i = 8;
            bit = 1;
            while (i < 16) {
                if ((layout2 & bit) != 0) {
                    node.count = (byte)(node.count + 1);
                    child = new node_trie();
                    node.children[i] = child;
                    this.deserialize(in, child, depth + 1);
                }
                i = (byte)(i + 1);
                bit = (byte)(bit * 2);
            }
        } else {
            int i = 0;
            byte bit = 1;
            while (i < 8) {
                if ((layout1 & bit) != 0) {
                    node.count = (byte)(node.count + 1);
                    node.children[i] = THE_LEAF;
                }
                i = (byte)(i + 1);
                bit = (byte)(bit * 2);
            }
            i = 8;
            bit = 1;
            while (i < 16) {
                if ((layout2 & bit) != 0) {
                    node.count = (byte)(node.count + 1);
                    node.children[i] = THE_LEAF;
                }
                i = (byte)(i + 1);
                bit = (byte)(bit * 2);
            }
        }
    }

    public void deserialize(byte[] data) {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        for (int i = 0; i < 16; i = (int)((byte)(i + 1))) {
            this.root.children[i] = null;
        }
        this.deserialize(in, this.root, 0);
    }

    public Iterator<byte[]> iterator() {
        return new TrieIterator();
    }

    private class TrieIterator
    implements Iterator<byte[]> {
        Stack<Pair<node_trie, Integer>> state = new Stack();

        void goToNext() {
            while (!this.state.isEmpty()) {
                Pair<node_trie, Integer> top = this.state.pop();
                node_trie n = top.getFirst();
                int i = top.getSecond();
                while (++i < n.children.length && n.children[i] == null) {
                }
                if (i >= n.children.length) continue;
                this.state.push(new Pair<node_trie, Integer>(n, i));
                if (this.state.size() >= 32) break;
                this.state.push(new Pair<node_trie, Integer>((node_trie)n.children[i], -1));
            }
        }

        public TrieIterator() {
            this.state.push(new Pair<node_trie, Integer>(UUIDTrie.this.root, -1));
            this.goToNext();
        }

        @Override
        public boolean hasNext() {
            return !this.state.isEmpty();
        }

        @Override
        public byte[] next() {
            byte[] result = null;
            if (this.hasNext()) {
                result = new byte[16];
                int idx = 0;
                Iterator i = this.state.iterator();
                while (i.hasNext()) {
                    byte high = ((Integer)((Pair)i.next()).getSecond()).byteValue();
                    if (high > 7) {
                        high = (byte)(7 - high);
                    }
                    byte low = ((Integer)((Pair)i.next()).getSecond()).byteValue();
                    result[idx++] = (byte)(16 * high + low);
                }
                this.goToNext();
            }
            return result;
        }

        @Override
        public void remove() {
            if (this.state.size() < 16) {
                throw new IllegalStateException("TrieIterator.remove: the iterator has no current object to remove.");
            }
            if (this.state.peek().getSecond() < 0) {
                throw new IllegalStateException("TrieIterator.remove: the iterator has no current object to remove.");
            }
            Pair<node_trie, Integer> curr = this.state.peek();
            curr.getFirst().children[curr.getSecond().intValue()] = null;
            curr.getFirst().count = (byte)(curr.getFirst().count - 1);
            while (curr.getFirst().count == 0) {
                this.state.pop();
                if (this.state.isEmpty()) break;
                curr = this.state.peek();
                curr.getFirst().children[curr.getSecond().intValue()] = null;
                curr.getFirst().count = (byte)(curr.getFirst().count - 1);
            }
        }
    }

    private static final class node_trie
    extends trie {
        trie[] children = new trie[16];
        byte count = 0;

        private node_trie() {
        }

        @Override
        public Object clone() {
            node_trie cl = new node_trie();
            cl.count = this.count;
            cl.children = new trie[this.children.length];
            for (int i = 0; i < this.children.length; ++i) {
                cl.children[i] = (trie)this.children[i].clone();
            }
            return cl;
        }
    }

    private static final class leaf_trie
    extends trie {
        private leaf_trie() {
        }

        @Override
        public Object clone() {
            return THE_LEAF;
        }
    }

    private static class trie
    implements Cloneable {
        private trie() {
        }

        public Object clone() {
            return this;
        }
    }
}

