/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.atom;

import java.util.HashSet;
import java.util.Set;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPlainLink;

public class HGBergeLink
extends HGPlainLink {
    private int tailIndex = 0;

    public HGBergeLink(HGHandle ... targets) {
        super(targets);
    }

    public HGBergeLink(int tailIndex, HGHandle ... targets) {
        super(targets);
        this.tailIndex = tailIndex;
    }

    public HGBergeLink(HGHandle[] head, HGHandle[] tail) {
        HGHandle[] targets = new HGHandle[head.length + tail.length];
        System.arraycopy(head, 0, targets, 0, head.length);
        System.arraycopy(tail, 0, targets, head.length, tail.length);
        this.tailIndex = head.length;
    }

    public Set<HGHandle> getHead() {
        HashSet<HGHandle> set = new HashSet<HGHandle>();
        for (int i = 0; i < this.tailIndex; ++i) {
            set.add(this.getTargetAt(i));
        }
        return set;
    }

    public Set<HGHandle> getTail() {
        HashSet<HGHandle> set = new HashSet<HGHandle>();
        for (int i = this.tailIndex; i < this.getArity(); ++i) {
            set.add(this.getTargetAt(i));
        }
        return set;
    }

    public int getTailIndex() {
        return this.tailIndex;
    }

    public void setTailIndex(int tailIndex) {
        this.tailIndex = tailIndex;
    }
}

