/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.atom;

import org.hypergraphdb.HGHandle;

public class HGAtomRef {
    private HGHandle referent;
    private Mode mode;

    public HGAtomRef(HGHandle referent, Mode mode) {
        this.referent = referent;
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean isHard() {
        return this.mode == Mode.hard;
    }

    public boolean isSymbolic() {
        return this.mode == Mode.symbolic;
    }

    public boolean isFloating() {
        return this.mode == Mode.floating;
    }

    public HGHandle getReferent() {
        return this.referent;
    }

    public static enum Mode {
        hard(0),
        symbolic(1),
        floating(2);

        private byte code;

        private Mode(byte code) {
            this.code = code;
        }

        public byte getCode() {
            return this.code;
        }

        public static Mode get(byte code) {
            if (code == 0) {
                return hard;
            }
            if (code == 1) {
                return symbolic;
            }
            return floating;
        }
    }
}

