/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.algorithms;

import java.util.HashSet;
import java.util.Set;
import org.hypergraphdb.HGGraphHolder;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGLink;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.algorithms.HGTraversal;
import org.hypergraphdb.query.HGAtomPredicate;
import org.hypergraphdb.util.Pair;
import org.hypergraphdb.util.TargetSetIterator;

public class HyperTraversal
implements HGTraversal,
HGGraphHolder {
    private transient HyperGraph graph;
    private HGTraversal flatTraversal;
    private HGAtomPredicate linkPredicate;
    private Set<HGHandle> visited = new HashSet<HGHandle>();
    private TargetSetIterator titer = null;
    private HGHandle currentLink = null;

    public HyperTraversal() {
    }

    public HyperTraversal(HyperGraph graph, HGTraversal flatTraversal) {
        this.graph = graph;
        this.flatTraversal = flatTraversal;
    }

    public HyperTraversal(HyperGraph graph, HGTraversal flatTraversal, HGAtomPredicate linkPredicate) {
        this.graph = graph;
        this.flatTraversal = flatTraversal;
        this.linkPredicate = linkPredicate;
    }

    @Override
    public boolean hasNext() {
        if (this.currentLink == null || !this.titer.hasNext()) {
            return this.flatTraversal.hasNext();
        }
        return true;
    }

    @Override
    public boolean isVisited(HGHandle handle) {
        return this.visited.contains(handle) || this.flatTraversal.isVisited(handle);
    }

    @Override
    public Pair<HGHandle, HGHandle> next() {
        if (this.currentLink != null && this.titer.hasNext()) {
            return new Pair<HGHandle, HGHandle>(this.currentLink, this.titer.next());
        }
        Pair<HGHandle, HGHandle> p = this.flatTraversal.next();
        Object atom = this.graph.get(p.getSecond());
        if (atom instanceof HGLink && (this.linkPredicate == null || this.linkPredicate.satisfies(this.graph, p.getSecond()))) {
            this.currentLink = p.getSecond();
            this.titer = new TargetSetIterator((HGLink)this.graph.get(this.currentLink));
        } else {
            this.currentLink = null;
            this.titer = null;
        }
        return p;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public HGTraversal getFlatTraversal() {
        return this.flatTraversal;
    }

    public void setFlatTraversal(HGTraversal flatTraversal) {
        this.flatTraversal = flatTraversal;
    }

    public HGAtomPredicate getLinkPredicate() {
        return this.linkPredicate;
    }

    public void setLinkPredicate(HGAtomPredicate linkPredicate) {
        this.linkPredicate = linkPredicate;
    }

    @Override
    public void setHyperGraph(HyperGraph graph) {
        this.graph = graph;
    }

    public HyperGraph getHyperGraph() {
        return this.graph;
    }
}

