/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.algorithms;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.algorithms.HGALGenerator;
import org.hypergraphdb.algorithms.HGTraversal;
import org.hypergraphdb.util.Pair;

public class HGBreadthFirstTraversal
implements HGTraversal {
    private HGHandle startAtom;
    private int maxDistance;
    private Map<HGHandle, Boolean> examined = new HashMap<HGHandle, Boolean>();
    private Queue<Pair<Pair<HGHandle, HGHandle>, Integer>> to_explore = new LinkedList<Pair<Pair<HGHandle, HGHandle>, Integer>>();
    private HGALGenerator adjListGenerator;
    private boolean initialized = false;

    private void init() {
        this.maxDistance = Integer.MAX_VALUE;
        this.examined.put(this.startAtom, Boolean.TRUE);
        this.advance(this.startAtom, 0);
        this.initialized = true;
    }

    private void advance(HGHandle from, int distance) {
        if (distance >= this.maxDistance) {
            return;
        }
        HGSearchResult<Pair<HGHandle, HGHandle>> i = this.adjListGenerator.generate(from);
        Integer dd = distance + 1;
        while (i.hasNext()) {
            Pair p = (Pair)i.next();
            if (this.examined.containsKey(p.getSecond())) continue;
            this.to_explore.add(new Pair<Pair, Integer>(p, dd));
            this.examined.put((HGHandle)p.getSecond(), Boolean.FALSE);
        }
        i.close();
    }

    public void setStartAtom(HGHandle startAtom) {
        this.startAtom = startAtom;
    }

    public HGHandle getStartAtom() {
        return this.startAtom;
    }

    public HGALGenerator getAdjListGenerator() {
        return this.adjListGenerator;
    }

    public void setAdjListGenerator(HGALGenerator adjListGenerator) {
        this.adjListGenerator = adjListGenerator;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public HGBreadthFirstTraversal() {
    }

    public HGBreadthFirstTraversal(HGHandle startAtom, HGALGenerator adjListGenerator) {
        this(startAtom, adjListGenerator, Integer.MAX_VALUE);
    }

    public HGBreadthFirstTraversal(HGHandle startAtom, HGALGenerator adjListGenerator, int maxDistance) {
        this.maxDistance = maxDistance;
        this.startAtom = startAtom;
        this.adjListGenerator = adjListGenerator;
        this.init();
    }

    @Override
    public boolean hasNext() {
        if (!this.initialized) {
            this.init();
        }
        return !this.to_explore.isEmpty();
    }

    @Override
    public boolean isVisited(HGHandle handle) {
        Boolean b = this.examined.get(handle);
        return b != null && b != false;
    }

    @Override
    public Pair<HGHandle, HGHandle> next() {
        if (!this.initialized) {
            this.init();
        }
        Pair<HGHandle, HGHandle> rvalue = null;
        if (!this.to_explore.isEmpty()) {
            Pair<Pair<HGHandle, HGHandle>, Integer> x = this.to_explore.remove();
            rvalue = x.getFirst();
            this.examined.put(rvalue.getSecond(), Boolean.TRUE);
            this.advance(rvalue.getSecond(), x.getSecond());
        }
        return rvalue;
    }

    public void reset() {
        this.examined.clear();
        this.to_explore.clear();
        this.init();
    }
}

