/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.algorithms;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.algorithms.HGALGenerator;
import org.hypergraphdb.atom.HGAtomSet;
import org.hypergraphdb.handle.HGLiveHandle;
import org.hypergraphdb.util.Mapping;
import org.hypergraphdb.util.Pair;

public class GraphClassics {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasCycles(HGHandle root, HGALGenerator adjencyGenerator) {
        HGAtomSet visited = new HGAtomSet();
        LinkedList<HGHandle> to_explore = new LinkedList<HGHandle>();
        to_explore.add(root);
        while (!to_explore.isEmpty()) {
            HGHandle next = (HGHandle)to_explore.remove();
            visited.add(next);
            HGSearchResult<Pair<HGHandle, HGHandle>> rs = adjencyGenerator.generate(next);
            try {
                while (rs.hasNext()) {
                    Pair x = (Pair)rs.next();
                    if (visited.contains(x.getSecond())) {
                        boolean bl = true;
                        return bl;
                    }
                    to_explore.add((HGHandle)x.getSecond());
                }
            }
            finally {
                rs.close();
            }
        }
        return false;
    }

    public static Double dijkstra(HGHandle start, HGHandle goal, HGALGenerator adjencyGenerator) {
        return GraphClassics.dijkstra(start, goal, adjencyGenerator, null, null, null);
    }

    public static Double dijkstra(HGHandle start, HGHandle goal, HGALGenerator adjencyGenerator, Mapping<HGHandle, Double> weight, Map<HGHandle, Double> distanceMatrix, Map<HGHandle, HGHandle> predecessorMatrix) {
        final HashMap<HGHandle, Double> dm = distanceMatrix == null ? new HashMap<HGHandle, Double>() : distanceMatrix;
        dm.put(start, 0.0);
        Comparator<HGHandle> comp = new Comparator<HGHandle>(){

            private int compareHandles(HGHandle left, HGHandle right) {
                HGPersistentHandle x = left instanceof HGPersistentHandle ? (HGPersistentHandle)left : ((HGLiveHandle)left).getPersistentHandle();
                HGPersistentHandle y = right instanceof HGPersistentHandle ? (HGPersistentHandle)right : ((HGLiveHandle)right).getPersistentHandle();
                return x.compareTo(y);
            }

            @Override
            public int compare(HGHandle left, HGHandle right) {
                Double l = (Double)dm.get(left);
                Double r = (Double)dm.get(right);
                if (l == null) {
                    if (r == null) {
                        return this.compareHandles(left, right);
                    }
                    return 1;
                }
                if (r == null) {
                    return -1;
                }
                int c = l.compareTo(r);
                if (c == 0) {
                    c = this.compareHandles(left, right);
                }
                return c;
            }
        };
        if (weight == null) {
            weight = new Mapping<HGHandle, Double>(){

                @Override
                public Double eval(HGHandle link) {
                    return 1.0;
                }
            };
        }
        HGAtomSet settled = new HGAtomSet();
        TreeSet<HGHandle> unsettled = new TreeSet<HGHandle>(comp);
        unsettled.add(start);
        while (!unsettled.isEmpty()) {
            HGHandle a = unsettled.first();
            unsettled.remove(a);
            if (a.equals(goal)) {
                return (Double)dm.get(goal);
            }
            settled.add(a);
            HGSearchResult<Pair<HGHandle, HGHandle>> neighbors = adjencyGenerator.generate(a);
            double weightCurrent = (Double)dm.get(a);
            while (neighbors.hasNext()) {
                Pair n = (Pair)neighbors.next();
                if (settled.contains(n.getSecond())) continue;
                Double weightN = (Double)dm.get(n.getSecond());
                Double weightAN = (Double)weight.eval((HGHandle)n.getFirst());
                if (weightN == null) {
                    dm.put((HGHandle)n.getSecond(), weightCurrent + weightAN);
                    unsettled.add((HGHandle)n.getSecond());
                    if (predecessorMatrix == null) continue;
                    predecessorMatrix.put((HGHandle)n.getSecond(), a);
                    continue;
                }
                if (!(weightN > weightCurrent + weightAN)) continue;
                unsettled.remove(n.getSecond());
                dm.put((HGHandle)n.getSecond(), weightCurrent + weightAN);
                unsettled.add((HGHandle)n.getSecond());
                if (predecessorMatrix == null) continue;
                predecessorMatrix.put((HGHandle)n.getSecond(), a);
            }
            neighbors.close();
        }
        return null;
    }

    public void bellman_ford() {
    }

    public void a_star() {
    }

    public void johnson() {
    }

    public void floyd_warshall() {
    }

    public void prim(HGHandle start, HGALGenerator adjencyGenerator, Mapping<HGHandle, Double> weight, Map<HGHandle, HGHandle> parentMatrix) {
    }

    public void kruskall(Iterator<HGHandle> links, Mapping<HGHandle, Double> weight, Map<HGHandle, HGHandle> parentMatrix) {
    }
}

