/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.algorithms;

import java.util.Iterator;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGLink;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.algorithms.HGALGenerator;
import org.hypergraphdb.query.HGAtomPredicate;
import org.hypergraphdb.util.CloseMe;
import org.hypergraphdb.util.Pair;
import org.hypergraphdb.util.TempLink;

public class DefaultALGenerator
implements HGALGenerator,
CloseMe {
    private HyperGraph hg;
    private TempLink tempLink = new TempLink(HyperGraph.EMTPY_HANDLE_SET);
    private HGAtomPredicate linkPredicate;
    private HGAtomPredicate siblingPredicate;
    private boolean returnPreceeding = true;
    private boolean returnSucceeding = true;
    private boolean reverseOrder = false;
    private boolean returnSource = false;
    private AdjIterator currIterator = null;

    public DefaultALGenerator() {
    }

    public DefaultALGenerator(HyperGraph graph) {
        this.hg = graph;
    }

    public DefaultALGenerator(HyperGraph hg2, HGAtomPredicate linkPredicate, HGAtomPredicate siblingPredicate) {
        this.hg = hg2;
        this.linkPredicate = linkPredicate;
        this.siblingPredicate = siblingPredicate;
    }

    public DefaultALGenerator(HyperGraph hg2, HGAtomPredicate linkPredicate, HGAtomPredicate siblingPredicate, boolean returnPreceeding, boolean returnSucceeding, boolean reverseOrder) {
        this.hg = hg2;
        this.linkPredicate = linkPredicate;
        this.siblingPredicate = siblingPredicate;
        this.returnPreceeding = returnPreceeding;
        this.returnSucceeding = returnSucceeding;
        this.reverseOrder = reverseOrder;
        if (!returnPreceeding && !returnSucceeding) {
            throw new HGException("DefaultALGenerator: attempt to construct with both returnSucceeding and returnPreceeding set to false.");
        }
    }

    public DefaultALGenerator(HyperGraph graph, HGAtomPredicate linkPredicate, HGAtomPredicate siblingPredicate, boolean returnPreceeding, boolean returnSucceeding, boolean reverseOrder, boolean returnSource) {
        this.hg = graph;
        this.linkPredicate = linkPredicate;
        this.siblingPredicate = siblingPredicate;
        this.returnPreceeding = returnPreceeding;
        this.returnSucceeding = returnSucceeding;
        this.reverseOrder = reverseOrder;
        this.returnSource = returnSource;
    }

    @Override
    public HGSearchResult<Pair<HGHandle, HGHandle>> generate(HGHandle h) {
        return new AdjIterator(h, this.hg.getIncidenceSet(h).getSearchResult(), true);
    }

    @Override
    public void close() {
        if (this.currIterator != null && this.currIterator.closeResultSet) {
            ((HGSearchResult)this.currIterator.linksIterator).close();
        }
    }

    public HyperGraph getGraph() {
        return this.hg;
    }

    public void setGraph(HyperGraph graph) {
        this.hg = graph;
    }

    public HGAtomPredicate getLinkPredicate() {
        return this.linkPredicate;
    }

    public void setLinkPredicate(HGAtomPredicate linkPredicate) {
        this.linkPredicate = linkPredicate;
    }

    public HGAtomPredicate getSiblingPredicate() {
        return this.siblingPredicate;
    }

    public void setSiblingPredicate(HGAtomPredicate siblingPredicate) {
        this.siblingPredicate = siblingPredicate;
    }

    public boolean isReturnPreceeding() {
        return this.returnPreceeding;
    }

    public void setReturnPreceeding(boolean returnPreceeding) {
        this.returnPreceeding = returnPreceeding;
    }

    public boolean isReturnSucceeding() {
        return this.returnSucceeding;
    }

    public void setReturnSucceeding(boolean returnSucceeding) {
        this.returnSucceeding = returnSucceeding;
    }

    public boolean isReverseOrder() {
        return this.reverseOrder;
    }

    public void setReverseOrder(boolean reverseOrder) {
        this.reverseOrder = reverseOrder;
    }

    public boolean isReturnSource() {
        return this.returnSource;
    }

    public void setReturnSource(boolean returnSource) {
        this.returnSource = returnSource;
    }

    private class AdjIterator
    implements HGSearchResult<Pair<HGHandle, HGHandle>> {
        HGHandle src;
        Iterator<HGHandle> linksIterator;
        HGLink currLink;
        HGHandle hCurrLink;
        Pair<HGHandle, HGHandle> current;
        TargetSetIterator tsIter;
        boolean closeResultSet;
        int minArity = 2;

        void getNextLink() {
            while (true) {
                if (!this.linksIterator.hasNext()) {
                    this.currLink = null;
                    if (this.closeResultSet) {
                        ((HGSearchResult)this.linksIterator).close();
                    }
                    return;
                }
                this.hCurrLink = this.linksIterator.next();
                if (DefaultALGenerator.this.linkPredicate != null && !DefaultALGenerator.this.linkPredicate.satisfies(DefaultALGenerator.this.hg, this.hCurrLink)) continue;
                if (DefaultALGenerator.this.hg.isLoaded(this.hCurrLink)) {
                    this.currLink = (HGLink)DefaultALGenerator.this.hg.get(this.hCurrLink);
                } else {
                    DefaultALGenerator.this.tempLink.setHandleArray(DefaultALGenerator.this.hg.getStore().getLink(DefaultALGenerator.this.hg.getPersistentHandle(this.hCurrLink)), 2);
                    this.currLink = DefaultALGenerator.this.tempLink;
                }
                if (this.currLink.getArity() < this.minArity) continue;
                this.tsIter.reset();
                if (this.tsIter.hasNext()) break;
            }
        }

        AdjIterator(HGHandle src, Iterator<HGHandle> linksIterator, boolean closeResultSet) {
            this.src = src;
            this.linksIterator = linksIterator;
            this.closeResultSet = closeResultSet;
            this.tsIter = DefaultALGenerator.this.reverseOrder ? new BTargetSetIterator() : new FTargetSetIterator();
            if (DefaultALGenerator.this.returnSource) {
                this.minArity = 1;
            }
            this.getNextLink();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.currLink != null;
        }

        @Override
        public Pair<HGHandle, HGHandle> next() {
            this.current = new Pair<HGHandle, HGHandle>(this.hCurrLink, this.tsIter.next());
            if (!this.tsIter.hasNext()) {
                this.getNextLink();
            }
            return this.current;
        }

        @Override
        public void close() {
            if (this.closeResultSet) {
                ((HGSearchResult)this.linksIterator).close();
            }
        }

        @Override
        public Pair<HGHandle, HGHandle> current() {
            return this.current;
        }

        @Override
        public boolean isOrdered() {
            return false;
        }

        @Override
        public boolean hasPrev() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Pair<HGHandle, HGHandle> prev() {
            throw new UnsupportedOperationException();
        }

        final class BTargetSetIterator
        extends TargetSetIterator {
            BTargetSetIterator() {
            }

            void filter() {
                do {
                    HGHandle h = AdjIterator.this.currLink.getTargetAt(this.pos);
                    if (!this.focus_seen && h.equals(AdjIterator.this.src)) {
                        this.focus_seen = true;
                        if (DefaultALGenerator.this.returnSource && DefaultALGenerator.this.siblingPredicate.satisfies(DefaultALGenerator.this.hg, AdjIterator.this.src)) {
                            return;
                        }
                        if (DefaultALGenerator.this.returnSucceeding) continue;
                        this.pos = -1;
                        return;
                    }
                    if (!DefaultALGenerator.this.siblingPredicate.satisfies(DefaultALGenerator.this.hg, h)) continue;
                    return;
                } while (--this.pos != -1);
            }

            @Override
            void reset() {
                this.pos = AdjIterator.this.currLink.getArity() - 1;
                this.focus_seen = false;
                if (!DefaultALGenerator.this.returnPreceeding) {
                    while (!AdjIterator.this.currLink.getTargetAt(this.pos--).equals(AdjIterator.this.src)) {
                    }
                    this.focus_seen = true;
                    if (DefaultALGenerator.this.returnSource && (DefaultALGenerator.this.siblingPredicate == null || DefaultALGenerator.this.siblingPredicate.satisfies(DefaultALGenerator.this.hg, AdjIterator.this.src))) {
                        ++this.pos;
                        return;
                    }
                    if (this.pos == -1) {
                        return;
                    }
                }
                if (DefaultALGenerator.this.siblingPredicate != null) {
                    this.filter();
                } else if (!this.focus_seen && AdjIterator.this.currLink.getTargetAt(this.pos).equals(AdjIterator.this.src)) {
                    this.focus_seen = true;
                    if (DefaultALGenerator.this.returnSource && (DefaultALGenerator.this.siblingPredicate == null || DefaultALGenerator.this.siblingPredicate.satisfies(DefaultALGenerator.this.hg, AdjIterator.this.src))) {
                        return;
                    }
                    if (!DefaultALGenerator.this.returnSucceeding) {
                        this.pos = -1;
                        return;
                    }
                    --this.pos;
                }
            }

            @Override
            void advance() {
                if (--this.pos == -1) {
                    return;
                }
                if (DefaultALGenerator.this.siblingPredicate != null) {
                    this.filter();
                } else if (!this.focus_seen && AdjIterator.this.currLink.getTargetAt(this.pos).equals(AdjIterator.this.src)) {
                    this.focus_seen = true;
                    if (DefaultALGenerator.this.returnSource) {
                        return;
                    }
                    this.pos = !DefaultALGenerator.this.returnSucceeding ? -1 : --this.pos;
                }
            }
        }

        final class FTargetSetIterator
        extends TargetSetIterator {
            FTargetSetIterator() {
            }

            void filter() {
                do {
                    HGHandle h = AdjIterator.this.currLink.getTargetAt(this.pos);
                    if (!this.focus_seen && h.equals(AdjIterator.this.src)) {
                        this.focus_seen = true;
                        if (DefaultALGenerator.this.returnSource && DefaultALGenerator.this.siblingPredicate.satisfies(DefaultALGenerator.this.hg, h)) {
                            return;
                        }
                        if (DefaultALGenerator.this.returnSucceeding) continue;
                        this.pos = -1;
                        return;
                    }
                    if (!DefaultALGenerator.this.siblingPredicate.satisfies(DefaultALGenerator.this.hg, h)) continue;
                    return;
                } while (++this.pos != AdjIterator.this.currLink.getArity());
                this.pos = -1;
            }

            @Override
            void advance() {
                if (++this.pos == AdjIterator.this.currLink.getArity()) {
                    this.pos = -1;
                    return;
                }
                if (DefaultALGenerator.this.siblingPredicate != null) {
                    this.filter();
                } else if (!this.focus_seen && AdjIterator.this.currLink.getTargetAt(this.pos).equals(AdjIterator.this.src)) {
                    this.focus_seen = true;
                    if (DefaultALGenerator.this.returnSource) {
                        return;
                    }
                    if (!DefaultALGenerator.this.returnSucceeding || ++this.pos == AdjIterator.this.currLink.getArity()) {
                        this.pos = -1;
                    }
                }
            }

            @Override
            void reset() {
                this.pos = 0;
                this.focus_seen = false;
                if (!DefaultALGenerator.this.returnPreceeding) {
                    while (!AdjIterator.this.currLink.getTargetAt(this.pos++).equals(AdjIterator.this.src)) {
                    }
                    this.focus_seen = true;
                    if (DefaultALGenerator.this.returnSource && (DefaultALGenerator.this.siblingPredicate == null || DefaultALGenerator.this.siblingPredicate.satisfies(DefaultALGenerator.this.hg, AdjIterator.this.src))) {
                        --this.pos;
                        return;
                    }
                    if (this.pos == AdjIterator.this.currLink.getArity()) {
                        this.pos = -1;
                        return;
                    }
                }
                if (DefaultALGenerator.this.siblingPredicate != null) {
                    this.filter();
                } else if (!this.focus_seen && AdjIterator.this.currLink.getTargetAt(this.pos).equals(AdjIterator.this.src)) {
                    this.focus_seen = true;
                    if (DefaultALGenerator.this.returnSource && (DefaultALGenerator.this.siblingPredicate == null || DefaultALGenerator.this.siblingPredicate.satisfies(DefaultALGenerator.this.hg, AdjIterator.this.src))) {
                        return;
                    }
                    if (!DefaultALGenerator.this.returnSucceeding) {
                        this.pos = -1;
                        return;
                    }
                    ++this.pos;
                }
            }
        }

        private abstract class TargetSetIterator {
            boolean focus_seen = false;
            int pos = 0;

            private TargetSetIterator() {
            }

            abstract void reset();

            abstract void advance();

            boolean hasNext() {
                return this.pos != -1;
            }

            public HGHandle next() {
                HGHandle rvalue = AdjIterator.this.currLink.getTargetAt(this.pos);
                this.advance();
                return rvalue;
            }
        }
    }
}

