/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb;

import java.util.HashMap;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGLink;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HGQuery;
import org.hypergraphdb.HGRandomAccessResult;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.HGSearchable;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.query.And;
import org.hypergraphdb.query.AnyAtomCondition;
import org.hypergraphdb.query.AtomPartCondition;
import org.hypergraphdb.query.AtomTypeCondition;
import org.hypergraphdb.query.AtomValueCondition;
import org.hypergraphdb.query.BFSCondition;
import org.hypergraphdb.query.ComparisonOperator;
import org.hypergraphdb.query.DFSCondition;
import org.hypergraphdb.query.HGQueryCondition;
import org.hypergraphdb.query.IncidentCondition;
import org.hypergraphdb.query.IndexCondition;
import org.hypergraphdb.query.IndexedPartCondition;
import org.hypergraphdb.query.LinkCondition;
import org.hypergraphdb.query.MapCondition;
import org.hypergraphdb.query.Nothing;
import org.hypergraphdb.query.Or;
import org.hypergraphdb.query.OrderedLinkCondition;
import org.hypergraphdb.query.SubsumedCondition;
import org.hypergraphdb.query.SubsumesCondition;
import org.hypergraphdb.query.TargetCondition;
import org.hypergraphdb.query.TypePlusCondition;
import org.hypergraphdb.query.TypedValueCondition;
import org.hypergraphdb.query.cond2qry.ExpressionBasedQuery;
import org.hypergraphdb.type.HGAtomType;

class ResultSizeEstimation {
    static HashMap<Class<?>, Counter> countersMap = new HashMap();
    static Counter fullScanCounter = new FullScanCounter();

    ResultSizeEstimation() {
    }

    static long countResultSet(HyperGraph graph, HGQueryCondition cond) {
        return ResultSizeEstimation.countResultSet(HGQuery.make(graph, cond));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long countResultSet(HGQuery<?> q) {
        HGSearchResult<?> rs = q.execute();
        try {
            long result = 0L;
            while (rs.hasNext()) {
                ++result;
                rs.next();
            }
            long l = result;
            return l;
        }
        finally {
            try {
                rs.close();
            }
            catch (Throwable t) {}
        }
    }

    static {
        countersMap.put(AnyAtomCondition.class, new Counter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long count(HyperGraph graph, HGQueryCondition cond) {
                HGRandomAccessResult<HGPersistentHandle> rs = graph.indexByType.scanKeys();
                try {
                    long result = 0L;
                    while (rs.hasNext()) {
                        result += graph.indexByType.count((HGPersistentHandle)rs.next());
                    }
                    long l = result;
                    return l;
                }
                finally {
                    try {
                        rs.close();
                    }
                    catch (Throwable t) {}
                }
            }

            @Override
            public long cost(HyperGraph graph, HGQueryCondition cond) {
                return graph.indexByType.count();
            }
        });
        countersMap.put(AtomTypeCondition.class, new Counter(){

            @Override
            public long count(HyperGraph graph, HGQueryCondition x) {
                AtomTypeCondition cond = (AtomTypeCondition)x;
                HGHandle typeHandle = cond.getTypeHandle();
                if (typeHandle == null) {
                    typeHandle = graph.getTypeSystem().getTypeHandle(cond.getJavaClass());
                }
                return graph.indexByType.count(graph.getPersistentHandle(typeHandle));
            }

            @Override
            public long cost(HyperGraph graph, HGQueryCondition x) {
                return 1L;
            }
        });
        countersMap.put(TypePlusCondition.class, new Counter(){

            @Override
            public long count(HyperGraph graph, HGQueryCondition x) {
                TypePlusCondition cond = (TypePlusCondition)x;
                long result = 0L;
                for (HGHandle h : cond.getSubTypes(graph)) {
                    result += graph.indexByType.count(graph.getPersistentHandle(h));
                }
                return result;
            }

            @Override
            public long cost(HyperGraph graph, HGQueryCondition x) {
                TypePlusCondition cond = (TypePlusCondition)x;
                return cond.getSubTypes(graph).size();
            }
        });
        countersMap.put(TypedValueCondition.class, new Counter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long count(HyperGraph graph, HGQueryCondition x) {
                HGAtomType type;
                TypedValueCondition cond = (TypedValueCondition)x;
                HGHandle typeHandle = cond.getTypeHandle();
                if (typeHandle == null) {
                    typeHandle = graph.getTypeSystem().getTypeHandle(cond.getJavaClass());
                }
                if ((type = graph.getTypeSystem().getType(typeHandle)) instanceof HGSearchable && cond.getOperator() == ComparisonOperator.EQ) {
                    HGSearchResult rs = ((HGSearchable)((Object)type)).find(cond.getValue());
                    try {
                        long result = 0L;
                        while (rs.hasNext()) {
                            result += graph.indexByValue.count((HGPersistentHandle)rs.next());
                        }
                        long l = result;
                        return l;
                    }
                    finally {
                        try {
                            rs.close();
                        }
                        catch (Throwable t) {}
                    }
                }
                return ResultSizeEstimation.countResultSet(graph, x);
            }

            @Override
            public long cost(HyperGraph graph, HGQueryCondition x) {
                HGAtomType type;
                TypedValueCondition cond = (TypedValueCondition)x;
                HGHandle typeHandle = cond.getTypeHandle();
                if (typeHandle == null) {
                    typeHandle = graph.getTypeSystem().getTypeHandle(cond.getJavaClass());
                }
                if ((type = graph.getTypeSystem().getType(typeHandle)) instanceof HGSearchable && cond.getOperator() == ComparisonOperator.EQ) {
                    return 2L;
                }
                return Integer.MAX_VALUE;
            }
        });
        countersMap.put(AtomValueCondition.class, new Counter(){

            @Override
            public long count(HyperGraph graph, HGQueryCondition x) {
                AtomValueCondition vc = (AtomValueCondition)x;
                Object value = vc.getValue();
                if (value == null) {
                    throw new HGException("Count by null values is not supported yet.");
                }
                HGHandle type = graph.getTypeSystem().getTypeHandle(value);
                return countersMap.get(TypedValueCondition.class).count(graph, new TypedValueCondition(type, vc.getValue(), vc.getOperator()));
            }

            @Override
            public long cost(HyperGraph graph, HGQueryCondition x) {
                AtomValueCondition vc = (AtomValueCondition)x;
                Object value = vc.getValue();
                if (value == null) {
                    throw new HGException("Count by null values is not supported yet.");
                }
                HGHandle type = graph.getTypeSystem().getTypeHandle(value);
                return countersMap.get(TypedValueCondition.class).cost(graph, new TypedValueCondition(type, vc.getValue(), vc.getOperator()));
            }
        });
        countersMap.put(TargetCondition.class, new Counter(){

            @Override
            public long count(HyperGraph graph, HGQueryCondition x) {
                HGHandle h = ((TargetCondition)x).getLink();
                if (graph.isLoaded(h)) {
                    return ((HGLink)graph.get(h)).getArity();
                }
                HGPersistentHandle[] A = graph.getStore().getLink(graph.getPersistentHandle(h));
                if (A == null) {
                    throw new NullPointerException("No link data for handle " + h);
                }
                return A.length - 2;
            }

            @Override
            public long cost(HyperGraph graph, HGQueryCondition x) {
                return 1L;
            }
        });
        countersMap.put(IncidentCondition.class, new Counter(){

            @Override
            public long count(HyperGraph graph, HGQueryCondition x) {
                IncidentCondition cond = (IncidentCondition)x;
                return graph.getStore().getIncidenceSetCardinality(graph.getPersistentHandle(cond.getTarget()));
            }

            @Override
            public long cost(HyperGraph graph, HGQueryCondition x) {
                return 1L;
            }
        });
        countersMap.put(MapCondition.class, new Counter(){

            @Override
            public long count(HyperGraph graph, HGQueryCondition x) {
                Counter c = countersMap.get((x = ((MapCondition)x).getCondition()).getClass());
                return c == null ? ResultSizeEstimation.countResultSet(graph, x) : c.count(graph, x);
            }

            @Override
            public long cost(HyperGraph graph, HGQueryCondition x) {
                Counter c = countersMap.get((x = ((MapCondition)x).getCondition()).getClass());
                return c == null ? Integer.MAX_VALUE : c.cost(graph, x);
            }
        });
        countersMap.put(IndexCondition.class, new Counter(){

            @Override
            public long count(HyperGraph graph, HGQueryCondition x) {
                IndexCondition ic = (IndexCondition)x;
                if (ic.getOperator() == ComparisonOperator.EQ) {
                    return ic.getIndex().count(ic.getKey());
                }
                return ResultSizeEstimation.countResultSet(graph, ic);
            }

            @Override
            public long cost(HyperGraph graph, HGQueryCondition x) {
                IndexCondition ic = (IndexCondition)x;
                return ic.getOperator() == ComparisonOperator.EQ ? 1L : Integer.MAX_VALUE;
            }
        });
        countersMap.put(IndexedPartCondition.class, new Counter(){

            @Override
            public long count(HyperGraph graph, HGQueryCondition x) {
                IndexedPartCondition ip = (IndexedPartCondition)x;
                if (ip.getOperator() == ComparisonOperator.EQ) {
                    return ip.getIndex().count(ip.getPartValue());
                }
                return ResultSizeEstimation.countResultSet(graph, ip);
            }

            @Override
            public long cost(HyperGraph graph, HGQueryCondition x) {
                IndexedPartCondition ip = (IndexedPartCondition)x;
                return ip.getOperator() == ComparisonOperator.EQ ? 1L : Integer.MAX_VALUE;
            }
        });
        countersMap.put(AtomPartCondition.class, new Counter(){

            @Override
            public long count(HyperGraph graph, HGQueryCondition x) {
                throw new HGException("Can't count AtomPartCondition results: this condition can't be used alone.");
            }

            @Override
            public long cost(HyperGraph graph, HGQueryCondition x) {
                throw new HGException("Can't estimate cost of counting AtomPartCondition results: this condition can't be used alone.");
            }
        });
        countersMap.put(And.class, new Counter(){

            @Override
            public long count(HyperGraph graph, HGQueryCondition x) {
                ExpressionBasedQuery q = (ExpressionBasedQuery)HGQuery.make(graph, x);
                if ((x = q.getCondition()) == Nothing.Instance) {
                    return 0L;
                }
                And cond = (And)q.getCondition();
                if (cond.size() == 1) {
                    x = (HGQueryCondition)cond.get(0);
                    Counter c = countersMap.get(((HGQueryCondition)cond.get(0)).getClass());
                    if (c != null) {
                        return c.count(graph, x);
                    }
                }
                return ResultSizeEstimation.countResultSet(q);
            }

            @Override
            public long cost(HyperGraph graph, HGQueryCondition x) {
                ExpressionBasedQuery q = (ExpressionBasedQuery)HGQuery.make(graph, x);
                if ((x = q.getCondition()) == Nothing.Instance) {
                    return 0L;
                }
                And cond = (And)q.getCondition();
                if (cond.size() == 1) {
                    x = (HGQueryCondition)cond.get(0);
                    Counter c = countersMap.get(((HGQueryCondition)cond.get(0)).getClass());
                    if (c != null) {
                        return c.cost(graph, x);
                    }
                }
                return Integer.MAX_VALUE;
            }
        });
        countersMap.put(Or.class, new Counter(){

            @Override
            public long count(HyperGraph graph, HGQueryCondition x) {
                long result = 0L;
                for (HGQueryCondition cond : (Or)x) {
                    Counter c = countersMap.get(cond.getClass());
                    result += c == null ? ResultSizeEstimation.countResultSet(graph, cond) : c.count(graph, cond);
                }
                return result;
            }

            @Override
            public long cost(HyperGraph graph, HGQueryCondition x) {
                long cost = 0L;
                for (HGQueryCondition cond : (Or)x) {
                    Counter c = countersMap.get(cond.getClass());
                    if (c == null) {
                        return Integer.MAX_VALUE;
                    }
                    long cc = c.cost(graph, cond);
                    if (cc == Integer.MAX_VALUE) {
                        return cc;
                    }
                    cost += cc;
                }
                return cost;
            }
        });
        countersMap.put(SubsumesCondition.class, fullScanCounter);
        countersMap.put(SubsumedCondition.class, fullScanCounter);
        countersMap.put(LinkCondition.class, fullScanCounter);
        countersMap.put(OrderedLinkCondition.class, fullScanCounter);
        countersMap.put(BFSCondition.class, fullScanCounter);
        countersMap.put(DFSCondition.class, fullScanCounter);
    }

    static class FullScanCounter
    implements Counter {
        FullScanCounter() {
        }

        @Override
        public long count(HyperGraph graph, HGQueryCondition x) {
            return ResultSizeEstimation.countResultSet(graph, x);
        }

        @Override
        public long cost(HyperGraph graph, HGQueryCondition x) {
            return Integer.MAX_VALUE;
        }
    }

    public static interface Counter {
        public long count(HyperGraph var1, HGQueryCondition var2);

        public long cost(HyperGraph var1, HGQueryCondition var2);
    }
}

