/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import org.hypergraphdb.HGAtomAttrib;
import org.hypergraphdb.HGBidirectionalIndex;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGIndex;
import org.hypergraphdb.HGLink;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HGPlainLink;
import org.hypergraphdb.HGQuery;
import org.hypergraphdb.HGRandomAccessResult;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.atom.AtomProjection;
import org.hypergraphdb.atom.HGSubsumes;
import org.hypergraphdb.atom.HGTypeStructuralInfo;
import org.hypergraphdb.event.HGLoadPredefinedTypeEvent;
import org.hypergraphdb.handle.HGLiveHandle;
import org.hypergraphdb.storage.BAtoHandle;
import org.hypergraphdb.storage.BAtoString;
import org.hypergraphdb.transaction.TxMap;
import org.hypergraphdb.type.BonesOfBeans;
import org.hypergraphdb.type.HGAtomType;
import org.hypergraphdb.type.HGTypeConfiguration;
import org.hypergraphdb.type.JavaTypeMapper;
import org.hypergraphdb.type.LinkType;
import org.hypergraphdb.type.NullType;
import org.hypergraphdb.type.PlainLinkType;
import org.hypergraphdb.type.SubsumesType;
import org.hypergraphdb.type.Top;
import org.hypergraphdb.util.HGUtils;
import org.hypergraphdb.util.PredefinedTypesConfig;

public class HGTypeSystem {
    private static final String TYPE_ALIASES_DB_NAME = "hg_typesystem_type_alias";
    private static final String JAVA2HG_TYPES_DB_NAME = "hg_typesystem_java2hg_types";
    private static final String JAVA_PREDEFINED_TYPES_DB_NAME = "hg_typesystem_javapredefined_types";
    private static final int MAX_CLASS_TO_TYPE = 2000;
    public static final HGAtomType top = Top.getInstance();
    private HyperGraph graph = null;
    private Map<Class<?>, HGHandle> classToAtomType = null;
    private HGBidirectionalIndex<String, HGPersistentHandle> classToTypeDB = null;
    private HGBidirectionalIndex<String, HGPersistentHandle> aliases = null;
    private HGIndex<HGPersistentHandle, String> predefinedTypesDB = null;
    private JavaTypeMapper javaTypes = null;
    private ClassLoader classLoader;
    private HGLiveHandle topHandle;
    private HGLiveHandle nullTypeHandle;

    private HGBidirectionalIndex<String, HGPersistentHandle> getClassToTypeDB() {
        if (this.classToTypeDB == null) {
            this.classToTypeDB = this.graph.getStore().getBidirectionalIndex(JAVA2HG_TYPES_DB_NAME, BAtoString.getInstance(), BAtoHandle.getInstance(this.graph.getHandleFactory()), null, true);
        }
        return this.classToTypeDB;
    }

    private HGBidirectionalIndex<String, HGPersistentHandle> getAliases() {
        if (this.aliases == null) {
            this.aliases = this.graph.getStore().getBidirectionalIndex(TYPE_ALIASES_DB_NAME, BAtoString.getInstance(), BAtoHandle.getInstance(this.graph.getHandleFactory()), null, true);
        }
        return this.aliases;
    }

    private HGIndex<HGPersistentHandle, String> getPredefinedTypesDB() {
        if (this.predefinedTypesDB == null) {
            this.predefinedTypesDB = this.graph.getStore().getIndex(JAVA_PREDEFINED_TYPES_DB_NAME, BAtoHandle.getInstance(this.graph.getHandleFactory()), BAtoString.getInstance(), null, true);
        }
        return this.predefinedTypesDB;
    }

    void addPrimitiveTypeToStore(HGPersistentHandle handle) {
        HGPersistentHandle[] layout = new HGPersistentHandle[]{this.topHandle.getPersistentHandle(), this.graph.getHandleFactory().nullHandle()};
        this.graph.getStore().store(handle, layout);
        this.graph.indexByType.addEntry(this.topHandle.getPersistentHandle(), handle);
    }

    void bootstrap(HGTypeConfiguration typeConfiguration) {
        PredefinedTypesConfig config = PredefinedTypesConfig.loadFromResource(this.graph.getHandleFactory(), typeConfiguration.getPredefinedTypes());
        top.setHyperGraph(this.graph);
        this.topHandle = this.graph.cache.atomRead(config.getHandleOf(top.getClass()), top, new HGAtomAttrib());
        this.classToAtomType.put(Top.class, this.topHandle);
        this.classToAtomType.put(Object.class, this.topHandle);
        this.graph.cache.freeze(this.topHandle);
        PlainLinkType plainLinktype = new PlainLinkType();
        plainLinktype.setHyperGraph(this.graph);
        HGLiveHandle plainLinkHandle = this.graph.cache.atomRead(config.getHandleOf(plainLinktype.getClass()), plainLinktype, new HGAtomAttrib());
        this.classToAtomType.put(HGPlainLink.class, plainLinkHandle);
        this.graph.cache.freeze(plainLinkHandle);
        LinkType linkType = new LinkType();
        linkType.setHyperGraph(this.graph);
        HGLiveHandle linkHandle = this.graph.cache.atomRead(config.getHandleOf(linkType.getClass()), linkType, new HGAtomAttrib());
        this.classToAtomType.put(HGLink.class, linkHandle);
        this.graph.cache.freeze(linkHandle);
        SubsumesType subsumesType = new SubsumesType();
        subsumesType.setHyperGraph(this.graph);
        HGLiveHandle subsumesHandle = this.graph.cache.atomRead(config.getHandleOf(subsumesType.getClass()), subsumesType, new HGAtomAttrib());
        this.classToAtomType.put(HGSubsumes.class, subsumesHandle);
        this.graph.cache.freeze(subsumesHandle);
        NullType nullType = new NullType();
        nullType.setHyperGraph(this.graph);
        this.nullTypeHandle = this.graph.cache.atomRead(config.getHandleOf(NullType.class), nullType, new HGAtomAttrib());
        this.graph.cache.freeze(this.nullTypeHandle);
        if (this.graph.getStore().getLink(this.topHandle.getPersistentHandle()) == null) {
            this.addPrimitiveTypeToStore(this.topHandle.getPersistentHandle());
            this.addPrimitiveTypeToStore(plainLinkHandle.getPersistentHandle());
            this.addPrimitiveTypeToStore(linkHandle.getPersistentHandle());
            this.addPrimitiveTypeToStore(subsumesHandle.getPersistentHandle());
            this.graph.add((Object)new HGSubsumes((HGHandle)this.topHandle.getPersistentHandle(), (HGHandle)linkHandle.getPersistentHandle()), subsumesHandle.getPersistentHandle());
            this.graph.add((Object)new HGSubsumes((HGHandle)linkHandle.getPersistentHandle(), (HGHandle)plainLinkHandle.getPersistentHandle()), subsumesHandle.getPersistentHandle());
            this.graph.add((Object)new HGSubsumes((HGHandle)plainLinkHandle.getPersistentHandle(), (HGHandle)subsumesHandle.getPersistentHandle()), subsumesHandle.getPersistentHandle());
            for (HGPersistentHandle typeHandle : config.getHandles()) {
                Class<? extends HGAtomType> cl = config.getTypeImplementation(typeHandle);
                if (cl.equals(Top.class) || cl.equals(LinkType.class) || cl.equals(PlainLinkType.class) || cl.equals(SubsumesType.class)) continue;
                HGAtomType typeInstance = null;
                try {
                    typeInstance = cl.newInstance();
                }
                catch (Exception ex) {
                    System.err.println("[HYPERGRAPHDB WARNING]: failed to create instance of type '" + cl.getName() + "'");
                    ex.printStackTrace(System.err);
                }
                List<Class<?>> targets = config.getMappedClasses(typeHandle);
                if (targets.isEmpty()) {
                    this.addPredefinedType(typeHandle, typeInstance, null);
                    continue;
                }
                for (Class<?> target : targets) {
                    this.addPredefinedType(typeHandle, typeInstance, target);
                }
            }
        }
        this.javaTypes = typeConfiguration.getJavaTypeMapper();
        this.javaTypes.setHyperGraph(this.graph);
        this.getTypeHandle(AtomProjection.class);
    }

    public void storePrimitiveTypes(String resource) {
        InputStream resourceIn = this.getClass().getResourceAsStream(resource);
        if (resourceIn == null) {
            throw new HGException("Fatal error: could not load primitive types from " + resource + ", this resource could not be found!");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(resourceIn));
        try {
            String line = reader.readLine();
            while (line != null) {
                if ((line = line.trim()).length() != 0 && !line.startsWith("#")) {
                    StringTokenizer tok = new StringTokenizer(line, " ");
                    if (tok.countTokens() < 2) {
                        throw new HGException("Fatal error: could not load primitive types from " + resource + ", the line " + line + " is ill formed.");
                    }
                    String pHandleStr = tok.nextToken();
                    String typeClassName = tok.nextToken();
                    Class<?> typeClass = Class.forName(typeClassName);
                    HGAtomType type = (HGAtomType)typeClass.newInstance();
                    type.setHyperGraph(this.graph);
                    HGPersistentHandle pHandle = this.graph.getHandleFactory().makeHandle(pHandleStr);
                    if (tok.hasMoreTokens()) {
                        while (tok.hasMoreTokens()) {
                            String valueClassName = tok.nextToken();
                            Class<?> valueClass = Class.forName(valueClassName);
                            this.addPredefinedType(pHandle, type, valueClass);
                        }
                    } else {
                        this.addPredefinedType(pHandle, type, null);
                    }
                }
                line = reader.readLine();
            }
        }
        catch (IOException ex) {
            throw new HGException("Fatal error: could not load primitive types from " + resource + " due to an IO exception!", ex);
        }
        catch (ClassNotFoundException ex) {
            throw new HGException("Fatal error: could not load primitive types from " + resource + " due to a missing class from the classpath: " + ex.getMessage(), ex);
        }
        catch (Throwable t) {
            throw new HGException("Fatal error: could not load primitive types from " + resource, t);
        }
    }

    HGLiveHandle loadPredefinedType(HGPersistentHandle pHandle) {
        this.graph.getEventManager().dispatch(this.graph, new HGLoadPredefinedTypeEvent(pHandle));
        HGLiveHandle result = this.graph.cache.get(pHandle);
        if (result != null) {
            return result;
        }
        String classname = this.getPredefinedTypesDB().findFirst(pHandle);
        if (classname == null) {
            throw new HGException("Unable to load predefined type with handle " + pHandle + " please review the documentation about predefined types and how to hook them with the HyperGraph type system.");
        }
        try {
            Class<?> clazz = this.loadClass(classname);
            HGAtomType type = (HGAtomType)clazz.newInstance();
            type.setHyperGraph(this.graph);
            return (HGLiveHandle)this.addPredefinedType(pHandle, type, null);
        }
        catch (Throwable ex) {
            throw new HGException("Could not create predefined type instance with " + classname + " for type " + pHandle + ": " + ex.toString(), ex);
        }
    }

    public void defineTypeAtom(final HGPersistentHandle handle, final Class<?> clazz) {
        if (this.graph.getTransactionManager().getContext().getCurrent() != null) {
            this.graph.define(handle, this.nullTypeHandle, this.graph.getHandleFactory().nullHandle(), null, new Object());
            this.classToAtomType.put(clazz, handle);
            this.getClassToTypeDB().addEntry(clazz.getName(), this.graph.getPersistentHandle(handle));
            HGHandle h = this.defineNewJavaTypeTransaction(handle, clazz);
            if (h == null) {
                throw new HGException("Could not create HyperGraph type for class '" + clazz.getName() + "'");
            }
            if (!h.equals(handle)) {
                throw new HGException("The class '" + clazz.getName() + "' already has a HyperGraph Java:" + h);
            }
        } else {
            this.graph.getTransactionManager().transact(new Callable<HGHandle>(){

                @Override
                public HGHandle call() {
                    HGTypeSystem.this.graph.define(handle, HGTypeSystem.this.nullTypeHandle, HGTypeSystem.this.graph.getHandleFactory().nullHandle(), null, new Object());
                    HGTypeSystem.this.classToAtomType.put(clazz, handle);
                    HGTypeSystem.this.getClassToTypeDB().addEntry(clazz.getName(), HGTypeSystem.this.graph.getPersistentHandle(handle));
                    HGHandle h = HGTypeSystem.this.defineNewJavaTypeTransaction(handle, clazz);
                    if (h == null) {
                        throw new HGException("Could not create HyperGraph type for class '" + clazz.getName() + "'");
                    }
                    if (!h.equals(handle)) {
                        throw new HGException("The class '" + clazz.getName() + "' already has a HyperGraph Java:" + h);
                    }
                    return h;
                }
            });
        }
    }

    HGHandle makeNewJavaType(Class<?> clazz) {
        HGHandle newHandle = this.graph.add(new Object(), this.nullTypeHandle);
        this.classToAtomType.put(clazz, newHandle);
        this.getClassToTypeDB().addEntry(clazz.getName(), this.graph.getPersistentHandle(newHandle));
        HGHandle inferred = this.defineNewJavaTypeTransaction(newHandle, clazz);
        if (inferred == null) {
            this.getClassToTypeDB().removeAllEntries(clazz.getName());
            this.classToAtomType.remove(clazz);
            this.graph.remove(newHandle);
            return null;
        }
        this.classToAtomType.put(clazz, inferred);
        return inferred;
    }

    HGHandle defineNewJavaTypeTransaction(HGHandle newHandle, Class<?> clazz) {
        HGAtomType inferredHGType = this.javaTypes.defineHGType(clazz, newHandle);
        if (inferredHGType == null) {
            return null;
        }
        HGHandle typeConstructor = this.getTypeHandle(inferredHGType.getClass());
        if (!typeConstructor.equals(this.getTop())) {
            this.graph.replace(newHandle, inferredHGType, typeConstructor);
        } else {
            this.graph.remove(newHandle);
            HGLiveHandle result = this.graph.cache.get(inferredHGType);
            this.classToAtomType.put(clazz, result);
            this.getClassToTypeDB().removeEntry(clazz.getName(), this.graph.getPersistentHandle(newHandle));
            this.getClassToTypeDB().addEntry(clazz.getName(), this.graph.getPersistentHandle(result));
            newHandle = result;
        }
        HGAtomType type = this.javaTypes.getJavaBinding(newHandle, inferredHGType, clazz);
        type.setHyperGraph(this.graph);
        newHandle = newHandle instanceof HGLiveHandle ? this.graph.cache.atomRefresh((HGLiveHandle)newHandle, type, true) : this.graph.cache.atomRead((HGPersistentHandle)newHandle, type, new HGAtomAttrib());
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            HGHandle interfaceHandle = this.getTypeHandle(interfaces[i]);
            if (interfaceHandle == null) {
                throw new HGException("Unable to infer HG type for interface " + interfaces[i].getName());
            }
            this.assertSubtype(interfaceHandle, newHandle);
        }
        if (clazz.getSuperclass() != null) {
            HGHandle superHandle = this.getTypeHandle(clazz.getSuperclass());
            if (superHandle == null) {
                throw new HGException("Unable to infer HG type for class " + clazz.getSuperclass().getName() + " the superclass of " + clazz.getName());
            }
            this.assertSubtype(superHandle, newHandle);
        } else if (clazz.isInterface()) {
            this.graph.add(new HGSubsumes(this.getTop(), newHandle));
        }
        return newHandle;
    }

    public void assertSubtype(HGHandle superType, HGHandle subType) {
        this.graph.add(new HGSubsumes(superType, subType));
        this.graph.getIndexManager().registerSubtype(superType, subType);
    }

    public HGTypeSystem(HyperGraph graph) {
        this.graph = graph;
        this.classToAtomType = new TxMap(graph.getTransactionManager(), new ClassToTypeCache());
        this.getAliases();
        this.getClassToTypeDB();
        this.getPredefinedTypesDB();
    }

    public HyperGraph getHyperGraph() {
        return this.graph;
    }

    public JavaTypeMapper getJavaTypeFactory() {
        return this.javaTypes;
    }

    public HGHandle getNullType() {
        return this.nullTypeHandle;
    }

    public HGHandle getTop() {
        return this.topHandle;
    }

    public Class<?> loadClass(String classname) {
        ClassLoader loader;
        ClassLoader classLoader = loader = this.classLoader == null ? Thread.currentThread().getContextClassLoader() : this.classLoader;
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        try {
            Class<?> clazz;
            if (classname.startsWith("[L")) {
                classname = classname.substring(2, classname.length() - 1);
                clazz = Array.newInstance(loader.loadClass(classname), 0).getClass();
            } else {
                clazz = loader.loadClass(classname);
            }
            return clazz;
        }
        catch (Throwable t) {
            throw new HGException("Could not load class " + classname, t);
        }
    }

    HGAtomType toJavaBinding(HGPersistentHandle handle, HGAtomType type) {
        String classname = this.getClassToTypeDB().findFirstByValue(handle);
        if (classname != null) {
            Class<?> clazz = this.loadClass(classname);
            type = this.javaTypes.getJavaBinding(handle, type, clazz);
            this.classToAtomType.put(clazz, handle);
        }
        return type;
    }

    public HGHandle addPredefinedType(final HGPersistentHandle handle, final HGAtomType type, final Class<?> clazz) {
        if (this.graph.getTransactionManager().getContext().getCurrent() != null) {
            return this.addPredefinedTypeTransaction(handle, type, clazz);
        }
        return this.graph.getTransactionManager().transact(new Callable<HGHandle>(){

            @Override
            public HGHandle call() {
                return HGTypeSystem.this.addPredefinedTypeTransaction(handle, type, clazz);
            }
        });
    }

    private HGHandle addPredefinedTypeTransaction(HGPersistentHandle handle, HGAtomType type, Class<?> clazz) {
        type.setHyperGraph(this.graph);
        if (this.graph.getStore().getLink(handle) == null) {
            this.addPrimitiveTypeToStore(handle);
            this.graph.add(new HGSubsumes(this.getTop(), (HGHandle)handle));
            try {
                if (type.getClass().getConstructor(new Class[0]) != null) {
                    this.getPredefinedTypesDB().addEntry(handle, type.getClass().getName());
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        HGLiveHandle typeHandle = this.graph.cache.atomRead(handle, type, new HGAtomAttrib());
        this.graph.cache.freeze(typeHandle);
        this.classToAtomType.put(type.getClass(), this.classToAtomType.get(Top.class));
        if (clazz != null) {
            if (this.getClassToTypeDB().findFirst(clazz.getName()) != null) {
                this.classToTypeDB.removeAllEntries(clazz.getName());
            }
            this.classToTypeDB.addEntry(clazz.getName(), handle);
            this.classToAtomType.put(clazz, typeHandle);
        }
        return typeHandle;
    }

    public Class<?> getClassForType(HGHandle typeHandle) {
        String classname = this.getClassNameForType(typeHandle);
        return classname != null ? this.loadClass(classname) : null;
    }

    public void setTypeForClass(final HGHandle typeHandle, final Class<?> clazz) {
        this.graph.getTransactionManager().ensureTransaction(new Callable<HGHandle>(){

            @Override
            public HGHandle call() {
                HGTypeSystem.this.classToAtomType.put(clazz, typeHandle);
                HGTypeSystem.this.getClassToTypeDB().removeAllEntries(clazz.getName());
                HGTypeSystem.this.getClassToTypeDB().addEntry(clazz.getName(), HGTypeSystem.this.graph.getPersistentHandle(typeHandle));
                return null;
            }
        });
    }

    public String getClassNameForType(HGHandle typeHandle) {
        return this.getClassToTypeDB().findFirstByValue(this.graph.getPersistentHandle(typeHandle));
    }

    public HGAtomType getType(HGHandle handle) {
        return (HGAtomType)this.graph.get(handle);
    }

    public HGAtomType getType(String alias) {
        HGHandle handle = this.getTypeHandle(alias);
        if (handle != null) {
            return this.getType(handle);
        }
        return null;
    }

    public <T extends HGAtomType> T getAtomType(Class<?> clazz) {
        return (T)((HGAtomType)this.graph.get(this.getTypeHandle(clazz)));
    }

    public HGAtomType getAtomType(Object object) {
        return this.getType(this.getTypeHandle(object));
    }

    public HGAtomType getAtomType(HGHandle handle) {
        return (HGAtomType)((Object)this.getTypeHandle(handle));
    }

    public boolean hasType(Class<?> clazz) {
        if (this.classToAtomType.containsKey(clazz)) {
            return true;
        }
        return this.getClassToTypeDB().findFirst(clazz.getName()) != null;
    }

    public HGHandle getTypeHandleIfDefined(Class<?> clazz) {
        HGHandle typeHandle;
        if (clazz.isPrimitive()) {
            clazz = BonesOfBeans.wrapperEquivalentOf(clazz);
        }
        if ((typeHandle = this.classToAtomType.get(clazz)) != null) {
            return typeHandle;
        }
        HGPersistentHandle hgTypeHandle = (HGPersistentHandle)this.getClassToTypeDB().findFirst(clazz.getName());
        if (hgTypeHandle != null) {
            return hgTypeHandle;
        }
        return null;
    }

    public HGHandle getTypeHandle(final Class<?> clazz) {
        return this.graph.getTransactionManager().ensureTransaction(new Callable<HGHandle>(){

            @Override
            public HGHandle call() {
                HGHandle h = HGTypeSystem.this.getTypeHandleIfDefined(clazz);
                return h != null ? h : HGTypeSystem.this.makeNewJavaType(clazz);
            }
        });
    }

    public HGHandle getTypeHandle(String alias) {
        if (alias == null) {
            return null;
        }
        HGPersistentHandle handle = (HGPersistentHandle)this.getAliases().findFirst(alias);
        if (handle != null) {
            return this.graph.refreshHandle(handle);
        }
        return null;
    }

    public HGHandle getTypeHandle(HGHandle atomHandle) {
        HGPersistentHandle[] layout = this.graph.getStore().getLink(this.graph.getPersistentHandle(atomHandle));
        if (layout == null || layout.length == 0) {
            throw new HGException("Could not retrieve atom with handle " + this.graph.getPersistentHandle(atomHandle) + " from the HyperGraph store.");
        }
        HGLiveHandle live = this.graph.cache.get(layout[0]);
        return live == null ? layout[0] : live;
    }

    public HGHandle getTypeHandle(Object x) {
        if (x == null) {
            throw new NullPointerException("HGTypeSystem.getAtomType(Object) invoked with a null object -- and 'null' has no type.");
        }
        HGHandle atom = this.graph.getHandle(x);
        if (atom != null) {
            return this.getTypeHandle(atom);
        }
        return this.getTypeHandle(x.getClass());
    }

    public void addAlias(final HGHandle typeHandle, final String alias) {
        if (this.graph.getTransactionManager().getContext().getCurrent() != null) {
            this.addAliasTransaction(typeHandle, alias);
        } else {
            this.graph.getTransactionManager().transact(new Callable<Object>(){

                @Override
                public Object call() {
                    HGTypeSystem.this.addAliasTransaction(typeHandle, alias);
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAliasTransaction(HGHandle typeHandle, String alias) {
        HGBidirectionalIndex<String, HGPersistentHandle> aliases;
        HGBidirectionalIndex<String, HGPersistentHandle> hGBidirectionalIndex = aliases = this.getAliases();
        synchronized (hGBidirectionalIndex) {
            HGPersistentHandle handle = (HGPersistentHandle)aliases.findFirst(alias);
            if (handle != null) {
                throw new HGException("Alias '" + alias + "' already defined.");
            }
            aliases.addEntry(alias, this.graph.getPersistentHandle(typeHandle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> findAliases(HGHandle typeHandle) {
        HashSet<String> result = new HashSet<String>();
        HGRandomAccessResult<String> rs = this.getAliases().findByValue(this.graph.getPersistentHandle(typeHandle));
        try {
            while (rs.hasNext()) {
                result.add((String)rs.next());
            }
            HashSet<String> hashSet = result;
            return hashSet;
        }
        finally {
            HGUtils.closeNoException(rs);
        }
    }

    public HGTypeStructuralInfo getTypeMetaData(HGHandle typeHandle) {
        HGTypeStructuralInfo typeStruct = (HGTypeStructuralInfo)HGQuery.hg.getOne(this.graph, HGQuery.hg.and(HGQuery.hg.type(HGTypeStructuralInfo.class), HGQuery.hg.eq("typeHandle", typeHandle)));
        return typeStruct;
    }

    public void removeAlias(final String alias) {
        if (this.graph.getTransactionManager().getContext().getCurrent() != null) {
            this.removeAliasTransaction(alias);
        } else {
            this.graph.getTransactionManager().transact(new Callable<Object>(){

                @Override
                public Object call() {
                    HGTypeSystem.this.removeAliasTransaction(alias);
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAliasTransaction(String alias) {
        HGBidirectionalIndex<String, HGPersistentHandle> aliases;
        HGBidirectionalIndex<String, HGPersistentHandle> hGBidirectionalIndex = aliases = this.getAliases();
        synchronized (hGBidirectionalIndex) {
            HGPersistentHandle handle = (HGPersistentHandle)aliases.findFirst(alias);
            if (handle != null) {
                aliases.removeEntry(alias, handle);
            }
        }
    }

    void remove(final HGPersistentHandle typeHandle, final HGAtomType type) {
        this.graph.getTransactionManager().ensureTransaction(new Callable<Object>(){

            @Override
            public Object call() {
                HGTypeSystem.this.removeTransaction(typeHandle, type);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTransaction(HGPersistentHandle typeHandle, HGAtomType type) {
        List<HGHandle> subsumesLinks = HGQuery.hg.findAll(this.graph, HGQuery.hg.and(HGQuery.hg.incident(typeHandle), HGQuery.hg.type(HGSubsumes.class)));
        for (HGHandle h : subsumesLinks) {
            this.graph.remove(h);
        }
        HGHandle typeStruct = (HGHandle)HGQuery.hg.findOne(this.graph, HGQuery.hg.and(HGQuery.hg.type(HGTypeStructuralInfo.class), HGQuery.hg.eq("typeHandle", typeHandle)));
        if (typeStruct != null) {
            this.graph.remove(typeStruct);
        }
        HGBidirectionalIndex<String, HGPersistentHandle> aliases = this.getAliases();
        HGRandomAccessResult<String> rs = aliases.findByValue(typeHandle);
        try {
            while (rs.hasNext()) {
                aliases.removeEntry((String)rs.next(), typeHandle);
            }
        }
        finally {
            rs.close();
        }
        try {
            HGBidirectionalIndex<String, HGPersistentHandle> idx = this.getClassToTypeDB();
            rs = idx.findByValue(typeHandle);
            while (rs.hasNext()) {
                String classname = (String)rs.next();
                idx.removeEntry(classname, typeHandle);
                Class<?> clazz = this.loadClass(classname);
                this.classToAtomType.remove(clazz);
            }
        }
        catch (Throwable t) {
            throw new HGException(t);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable _) {}
            }
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private class ClassToTypeCache
    extends LinkedHashMap<Class<?>, HGHandle> {
        static final long serialVersionUID = -1L;

        public ClassToTypeCache() {
            super(1000, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Class<?>, HGHandle> eldest) {
            if (this.size() > 2000) {
                if (eldest.getValue() instanceof HGLiveHandle) {
                    HGLiveHandle h = (HGLiveHandle)eldest.getValue();
                    if (h.getRef() == null) {
                        return true;
                    }
                    if (((HGTypeSystem)HGTypeSystem.this).graph.cache.isFrozen(h)) {
                        return this.get(eldest.getKey()) == null;
                    }
                    return false;
                }
                HGLiveHandle h = ((HGTypeSystem)HGTypeSystem.this).graph.cache.get((HGPersistentHandle)eldest.getValue());
                if (h != null) {
                    eldest.setValue(h);
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

