/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb;

import java.util.Comparator;
import org.hypergraphdb.HGBidirectionalIndex;
import org.hypergraphdb.HGConfiguration;
import org.hypergraphdb.HGIndex;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HGRandomAccessResult;
import org.hypergraphdb.storage.BDBStorageImplementation;
import org.hypergraphdb.storage.ByteArrayConverter;
import org.hypergraphdb.storage.HGStoreImplementation;
import org.hypergraphdb.storage.StorageGraph;
import org.hypergraphdb.transaction.HGTransactionFactory;
import org.hypergraphdb.transaction.HGTransactionManager;

public class HGStore {
    private String databaseLocation;
    private HGConfiguration config;
    private HGTransactionManager transactionManager = null;
    private HGStoreImplementation impl = new BDBStorageImplementation();
    private ThreadLocal<StorageGraph> overlayGraph = new ThreadLocal();

    public HGStore(String database, HGConfiguration config) {
        this.databaseLocation = database;
        this.config = config;
        this.impl.startup(this, config);
        this.transactionManager = new HGTransactionManager(this.impl.getTransactionFactory());
        if (!config.isTransactional()) {
            this.transactionManager.disable();
        }
    }

    public HGTransactionFactory getTransactionFactory() {
        return this.impl.getTransactionFactory();
    }

    public HGTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public String getDatabaseLocation() {
        return this.databaseLocation;
    }

    public HGPersistentHandle store(HGPersistentHandle[] link) {
        return this.store(this.config.getHandleFactory().makeHandle(), link);
    }

    public HGPersistentHandle store(HGPersistentHandle handle, HGPersistentHandle[] link) {
        return this.impl.store(handle, link);
    }

    public HGPersistentHandle store(byte[] data) {
        HGPersistentHandle handle = this.config.getHandleFactory().makeHandle();
        this.store(handle, data);
        return handle;
    }

    public void store(HGPersistentHandle handle, byte[] data) {
        this.impl.store(handle, data);
    }

    public void removeLink(HGPersistentHandle handle) {
        this.impl.removeLink(handle);
    }

    public void removeData(HGPersistentHandle handle) {
        this.impl.removeData(handle);
    }

    public HGPersistentHandle[] getLink(HGPersistentHandle handle) {
        if (handle == null) {
            throw new NullPointerException("HGStore.getLink called with a null handle.");
        }
        if (this.overlayGraph.get() != null) {
            HGPersistentHandle[] result = null;
            result = this.overlayGraph.get().getLink(handle);
            if (result != null) {
                return result;
            }
        }
        return this.impl.getLink(handle);
    }

    public boolean containsLink(HGPersistentHandle handle) {
        if (handle == null) {
            throw new NullPointerException("HGStore.getLink called with a null handle.");
        }
        if (this.overlayGraph.get() != null && this.overlayGraph.get().getLink(handle) != null) {
            return true;
        }
        return this.impl.containsLink(handle);
    }

    public byte[] getData(HGPersistentHandle handle) {
        if (handle == null) {
            throw new NullPointerException("HGStore.getData called with a null handle.");
        }
        if (this.overlayGraph.get() != null) {
            byte[] result = null;
            result = this.overlayGraph.get().getData(handle);
            if (result != null) {
                return result;
            }
        }
        return this.impl.getData(handle);
    }

    public HGRandomAccessResult<HGPersistentHandle> getIncidenceResultSet(HGPersistentHandle handle) {
        return this.impl.getIncidenceResultSet(handle);
    }

    public long getIncidenceSetCardinality(HGPersistentHandle handle) {
        return this.impl.getIncidenceSetCardinality(handle);
    }

    public void addIncidenceLink(HGPersistentHandle handle, HGPersistentHandle newLink) {
        this.impl.addIncidenceLink(handle, newLink);
    }

    public void removeIncidenceLink(HGPersistentHandle handle, HGPersistentHandle oldLink) {
        this.impl.removeIncidenceLink(handle, oldLink);
    }

    public void removeIncidenceSet(HGPersistentHandle handle) {
        if (handle == null) {
            throw new NullPointerException("HGStore.removeIncidenceSet called with a null handle.");
        }
        this.impl.removeIncidenceSet(handle);
    }

    public <KeyType, ValueType> HGIndex<KeyType, ValueType> getIndex(String name, ByteArrayConverter<KeyType> keyConverter, ByteArrayConverter<ValueType> valueConverter, Comparator<?> comparator, boolean allowCreate) {
        return this.impl.getIndex(name, keyConverter, valueConverter, comparator, false, allowCreate);
    }

    public <KeyType, ValueType> HGBidirectionalIndex<KeyType, ValueType> getBidirectionalIndex(String name, ByteArrayConverter<KeyType> keyConverter, ByteArrayConverter<ValueType> valueConverter, Comparator comparator, boolean allowCreate) {
        return (HGBidirectionalIndex)this.impl.getIndex(name, keyConverter, valueConverter, comparator, true, allowCreate);
    }

    public void removeIndex(String name) {
        this.impl.removeIndex(name);
    }

    public void close() {
        this.impl.shutdown();
    }

    public void attachOverlayGraph(StorageGraph sgraph) {
        this.overlayGraph.set(sgraph);
    }

    public void detachOverlayGraph() {
        this.overlayGraph.set(null);
    }
}

