/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb;

import java.util.Iterator;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGLink;

public class HGPlainLink
implements HGLink,
Iterable<HGHandle> {
    protected HGHandle[] outgoingSet;

    protected HGPlainLink() {
        this.outgoingSet = new HGHandle[0];
    }

    public HGPlainLink(HGHandle ... outgoingSet) {
        if (outgoingSet == null) {
            throw new HGException("Attempt to construct a link with a null outgoing set. If the link has arity 0, please constructor with a 0 length array of atoms.");
        }
        this.outgoingSet = outgoingSet;
    }

    @Override
    public int getArity() {
        return this.outgoingSet.length;
    }

    @Override
    public HGHandle getTargetAt(int i) {
        return this.outgoingSet[i];
    }

    @Override
    public void notifyTargetHandleUpdate(int i, HGHandle handle) {
        this.outgoingSet[i] = handle;
    }

    @Override
    public void notifyTargetRemoved(int i) {
        HGHandle[] newOutgoing = new HGHandle[this.outgoingSet.length - 1];
        System.arraycopy(this.outgoingSet, 0, newOutgoing, 0, i);
        System.arraycopy(this.outgoingSet, i + 1, newOutgoing, i, this.outgoingSet.length - i - 1);
        this.outgoingSet = newOutgoing;
    }

    @Override
    public Iterator<HGHandle> iterator() {
        return new Iterator<HGHandle>(){
            private int curr = 0;

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return this.curr < HGPlainLink.this.outgoingSet.length;
            }

            @Override
            public HGHandle next() {
                return HGPlainLink.this.outgoingSet[this.curr++];
            }
        };
    }
}

