/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb;

import org.hypergraphdb.HGHandleFactory;
import org.hypergraphdb.storage.HGStoreImplementation;
import org.hypergraphdb.type.HGTypeConfiguration;
import org.hypergraphdb.util.HGUtils;

public final class HGConfiguration {
    private HGHandleFactory handleFactory;
    private HGStoreImplementation storeImplementation;
    private boolean transactional;
    private boolean skipMaintenance;
    private boolean cancelMaintenance;
    private boolean skipOpenedEvent;
    private int maxCachedIncidenceSetSize;
    private boolean useSystemAtomAttributes;
    private HGTypeConfiguration typeConfiguration = new HGTypeConfiguration();

    public HGConfiguration() {
        this.resetDefaults();
    }

    public HGHandleFactory getHandleFactory() {
        if (this.handleFactory == null) {
            this.handleFactory = (HGHandleFactory)HGUtils.getImplementationOf(HGHandleFactory.class.getName(), "org.hypergraphdb.handle.UUIDHandleFactory");
        }
        return this.handleFactory;
    }

    public void setHandleFactory(HGHandleFactory handleFactory) {
        this.handleFactory = handleFactory;
    }

    public HGStoreImplementation getStoreImplementation() {
        if (this.storeImplementation == null) {
            this.storeImplementation = (HGStoreImplementation)HGUtils.getImplementationOf(HGStoreImplementation.class.getName(), "org.hypergraphdb.storage.BDBStorageImplementation");
        }
        return this.storeImplementation;
    }

    public void setStoreImplementation(HGStoreImplementation storeImplementation) {
        this.storeImplementation = storeImplementation;
    }

    public void resetDefaults() {
        this.transactional = true;
        this.skipMaintenance = false;
        this.cancelMaintenance = false;
        this.skipOpenedEvent = false;
        this.maxCachedIncidenceSetSize = 10000;
        this.useSystemAtomAttributes = true;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    public boolean getSkipMaintenance() {
        return this.skipMaintenance;
    }

    public void setSkipMaintenance(boolean skipMaintenance) {
        this.skipMaintenance = skipMaintenance;
    }

    public boolean getCancelMaintenance() {
        return this.cancelMaintenance;
    }

    public void setCancelMaintenance(boolean cancelMaintenance) {
        this.cancelMaintenance = cancelMaintenance;
    }

    public boolean getSkipOpenedEvent() {
        return this.skipOpenedEvent;
    }

    public void setSkipOpenedEvent(boolean skipOpenedEvent) {
        this.skipOpenedEvent = skipOpenedEvent;
    }

    public int getMaxCachedIncidenceSetSize() {
        return this.maxCachedIncidenceSetSize;
    }

    public void setMaxCachedIncidenceSetSize(int maxCachedIncidenceSetSize) {
        this.maxCachedIncidenceSetSize = maxCachedIncidenceSetSize;
    }

    public boolean isUseSystemAtomAttributes() {
        return this.useSystemAtomAttributes;
    }

    public void setUseSystemAtomAttributes(boolean useSystemAtomAttributes) {
        this.useSystemAtomAttributes = useSystemAtomAttributes;
    }

    public HGTypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }
}

