/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hypergraphdb.util.Pair;

public class TwoWayMap<X, Y> {
    private Map<X, Y> xtoy = new HashMap<X, Y>();
    private Map<Y, X> ytox = new HashMap<Y, X>();

    public void add(X x, Y y) {
        this.xtoy.put(x, y);
        this.ytox.put(y, x);
    }

    public Iterator<X> xiterator() {
        return this.xtoy.keySet().iterator();
    }

    public Iterator<Y> yiterator() {
        return this.ytox.keySet().iterator();
    }

    public Iterator<Pair<X, Y>> xyiterator() {
        final Iterator<Map.Entry<X, Y>> i = this.xtoy.entrySet().iterator();
        return new Iterator<Pair<X, Y>>(){

            @Override
            public void remove() {
                i.remove();
            }

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public Pair<X, Y> next() {
                Map.Entry e = (Map.Entry)i.next();
                return new Pair(e.getKey(), e.getValue());
            }
        };
    }

    public Set<Y> getYSet() {
        return this.ytox.keySet();
    }

    public Set<X> getXSet() {
        return this.xtoy.keySet();
    }

    public Y removeX(X x) {
        Y y = this.xtoy.remove(x);
        if (y != null) {
            this.ytox.remove(y);
        }
        return y;
    }

    public X removeY(Y y) {
        X x = this.ytox.remove(y);
        if (x != null) {
            this.xtoy.remove(x);
        }
        return x;
    }

    public Y getY(X x) {
        return this.xtoy.get(x);
    }

    public X getX(Y y) {
        return this.ytox.get(y);
    }

    public boolean containsX(X x) {
        return this.xtoy.containsKey(x);
    }

    public boolean containsY(Y y) {
        return this.ytox.containsKey(y);
    }

    public boolean isEmtpy() {
        return this.xtoy.isEmpty();
    }

    public void clear() {
        this.xtoy.clear();
        this.ytox.clear();
    }
}

