/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.hypergraphdb.util.Pair;

public class RefCountedMap<K, V>
implements Map<K, V> {
    Map<K, Pair<V, AtomicInteger>> implementation = null;

    public RefCountedMap(Map implementation) {
        this.implementation = implementation == null ? new ConcurrentHashMap<K, Pair<V, AtomicInteger>>() : implementation;
    }

    @Override
    public void clear() {
        this.implementation.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.implementation.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.implementation.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized V get(Object key) {
        Pair<V, AtomicInteger> p = this.implementation.get(key);
        return p == null ? null : (V)p.getFirst();
    }

    @Override
    public boolean isEmpty() {
        return this.implementation.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.implementation.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized V put(K key, V value) {
        Pair<V, AtomicInteger> existing;
        Pair<V, AtomicInteger> p = null;
        if (this.implementation instanceof ConcurrentMap) {
            p = new Pair<V, AtomicInteger>(value, new AtomicInteger(0));
            existing = ((ConcurrentMap)this.implementation).putIfAbsent(key, p);
            if (existing != null) {
                p = existing;
            }
        } else {
            existing = this.implementation;
            synchronized (existing) {
                p = this.implementation.get(key);
                if (p == null) {
                    p = new Pair<V, AtomicInteger>(value, new AtomicInteger(0));
                    this.implementation.put(key, p);
                }
            }
        }
        int current = p.getSecond().incrementAndGet();
        return (V)(current > 1 ? value : null);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public synchronized V remove(Object key) {
        Pair<V, AtomicInteger> p = this.implementation.get(key);
        if (p == null) {
            return null;
        }
        if (p.getSecond().decrementAndGet() == 0) {
            this.implementation.remove(key);
        }
        return p.getFirst();
    }

    @Override
    public int size() {
        return this.implementation.size();
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.implementation).equals(o);
    }

    @Override
    public int hashCode() {
        return ((Object)this.implementation).hashCode();
    }
}

