/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandleFactory;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.type.HGAtomType;
import org.hypergraphdb.util.TwoWayMap;

public class PredefinedTypesConfig {
    private TwoWayMap<HGPersistentHandle, Class<? extends HGAtomType>> handleToImpl = new TwoWayMap();
    private HashMap<HGPersistentHandle, List<Class<?>>> handleToTargets = new HashMap();

    private static ArrayList<String> readIt(InputStream in) {
        try {
            ArrayList<String> L = new ArrayList<String>();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String line = reader.readLine();
            while (line != null) {
                if (line.trim().length() > 0 && !line.startsWith("#")) {
                    L.add(line.trim());
                }
                line = reader.readLine();
            }
            return L;
        }
        catch (IOException ex) {
            throw new HGException(ex);
        }
    }

    private void loadTypes(HGHandleFactory handleFactory, ArrayList<String> L) {
        for (String line : L) {
            String[] A = line.split("\\s+");
            HGPersistentHandle handle = handleFactory.makeHandle(A[0]);
            String typeClassName = A[1];
            Class<?> typeClass = null;
            try {
                typeClass = Class.forName(typeClassName);
                this.handleToImpl.add(handle, typeClass);
            }
            catch (Exception ex) {
                System.err.println("[HYPERGRAPHDB WARNING]: unable to load type class '" + typeClassName + "'");
            }
            ArrayList targets = new ArrayList();
            this.handleToTargets.put(handle, targets);
            for (int i = 2; i < A.length; ++i) {
                Class<?> cl = null;
                try {
                    cl = Class.forName(A[i]);
                    targets.add(cl);
                    continue;
                }
                catch (Exception ex) {
                    System.err.println("[HYPERGRAPHDB WARNING]: unable to load class '" + A[i] + "' for HG type " + "'" + typeClassName + "'");
                }
            }
        }
    }

    private PredefinedTypesConfig() {
    }

    public Collection<HGPersistentHandle> getHandles() {
        return this.handleToImpl.getXSet();
    }

    public HGPersistentHandle getHandleOf(Class<? extends HGAtomType> typeImplementation) {
        return this.handleToImpl.getX(typeImplementation);
    }

    public Class<? extends HGAtomType> getTypeImplementation(HGPersistentHandle typeHandle) {
        return this.handleToImpl.getY(typeHandle);
    }

    public List<Class<?>> getMappedClasses(HGPersistentHandle typeHandle) {
        return this.handleToTargets.get(typeHandle);
    }

    public static PredefinedTypesConfig loadFromResource(HGHandleFactory handleFactory, String resource) {
        InputStream in = PredefinedTypesConfig.class.getResourceAsStream(resource);
        try {
            PredefinedTypesConfig config = new PredefinedTypesConfig();
            config.loadTypes(handleFactory, PredefinedTypesConfig.readIt(in));
            PredefinedTypesConfig predefinedTypesConfig = config;
            return predefinedTypesConfig;
        }
        catch (Exception ex) {
            throw new HGException(ex);
        }
        finally {
            try {
                in.close();
            }
            catch (Throwable t) {}
        }
    }

    public static PredefinedTypesConfig loadFromFile(HGHandleFactory handleFactory, File file) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            PredefinedTypesConfig config = new PredefinedTypesConfig();
            config.loadTypes(handleFactory, PredefinedTypesConfig.readIt(in));
            PredefinedTypesConfig predefinedTypesConfig = config;
            return predefinedTypesConfig;
        }
        catch (Exception ex) {
            throw new HGException(ex);
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (Throwable t) {}
        }
    }
}

