/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.util;

import java.io.Serializable;

public class Pair<F, S>
implements Serializable {
    private static final long serialVersionUID = 6572245056832188590L;
    int hash;
    private F first;
    private S second;

    public Pair(F first, S second) {
        this.first = first;
        this.second = second;
    }

    public F getFirst() {
        return this.first;
    }

    public S getSecond() {
        return this.second;
    }

    public int hashCode() {
        if (this.hash == 0) {
            int n = this.hash = this.first != null ? this.first.hashCode() : 0;
            if (this.second != null) {
                this.hash ^= this.second.hashCode();
            }
        }
        return this.hash;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Pair)) {
            return false;
        }
        Pair p = (Pair)other;
        if (this.first == null) {
            if (p.first != null) {
                return false;
            }
        } else {
            if (p.first == null) {
                return false;
            }
            if (!this.first.equals(p.first)) {
                return false;
            }
        }
        if (this.second == null) {
            return p.second == null;
        }
        if (p.second == null) {
            return false;
        }
        return this.second.equals(p.second);
    }

    public String toString() {
        return "pair(" + this.first + "," + this.second + ")";
    }
}

