/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hypergraphdb.HGRandomAccessResult;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.util.HGSortedSet;

public class LLRBTree<E>
extends AbstractSet<E>
implements HGSortedSet<E>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -1L;
    private static final boolean RED = true;
    private static final boolean BLACK = false;
    private final Node<E> UNKNOWN = new Node<Object>(null, false);
    private Node<E> root = null;
    private int size = 0;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Comparator<E> providedComparator = null;

    private static boolean isRed(Node<?> x) {
        return x == null ? false : x.color;
    }

    private static boolean isBlack(Node<?> x) {
        return x == null || !x.color;
    }

    private static boolean isRightLeaning(Node<?> x) {
        return x == null ? false : LLRBTree.isRed(x.right) && LLRBTree.isBlack(x.left);
    }

    private Node<E> insert(Node<E> h, E key) {
        int cmp;
        if (h == null) {
            ++this.size;
            return new Node<E>(key, true);
        }
        if (LLRBTree.isRed(h.left) && LLRBTree.isRed(h.right)) {
            h.colorFlip();
        }
        int n = cmp = this.providedComparator != null ? this.providedComparator.compare(key, h.key) : ((Comparable)key).compareTo(h.key);
        if (cmp < 0) {
            h.left = this.insert(h.left, key);
        } else if (cmp > 0) {
            h.right = this.insert(h.right, key);
        }
        if (LLRBTree.isRed(h.right) && LLRBTree.isBlack(h.left)) {
            h = h.rotateLeft();
        } else if (LLRBTree.isRed(h.left) && LLRBTree.isRed(h.left.left)) {
            h = h.rotateRight();
        }
        return h;
    }

    private Node<E> min(Node<E> h) {
        if (h == null) {
            return null;
        }
        Node<E> x = h;
        while (x.left != null) {
            x = x.left;
        }
        return x;
    }

    private Node<E> max(Node<E> h) {
        if (h == null) {
            return null;
        }
        Node<E> x = h;
        while (x.right != null) {
            x = x.right;
        }
        return x;
    }

    private Node<E> deleteMax(Node<E> h) {
        if (LLRBTree.isRed(h.left) && LLRBTree.isBlack(h.right)) {
            h = h.rotateRight();
        } else if (h.right == null) {
            return null;
        }
        if (LLRBTree.isBlack(h.right) && LLRBTree.isBlack(h.right.left)) {
            h = h.moveRedRight();
        }
        h.right = this.deleteMax(h.right);
        return h.fixUp();
    }

    private Node<E> deleteMin(Node<E> h) {
        if (h.left == null) {
            return null;
        }
        if (LLRBTree.isBlack(h.left) && LLRBTree.isBlack(h.left.left)) {
            h = h.moveRedLeft();
        }
        h.left = this.deleteMin(h.left);
        return h.fixUp();
    }

    private Node<E> delete(Node<E> h, E key) {
        int cmp;
        int n = cmp = this.providedComparator != null ? this.providedComparator.compare(key, h.key) : ((Comparable)key).compareTo(h.key);
        if (cmp < 0) {
            if (!LLRBTree.isRed(h.left) && !LLRBTree.isRed(h.left.left)) {
                h = h.moveRedLeft();
            }
            h.left = this.delete(h.left, key);
        } else {
            if (LLRBTree.isRed(h.left) && LLRBTree.isBlack(h.right)) {
                h = h.rotateRight();
                ++cmp;
            } else if (cmp == 0 && h.right == null) {
                --this.size;
                return null;
            }
            Node tmp = h;
            if (!LLRBTree.isRed(h.right) && !LLRBTree.isRed(h.right.left)) {
                tmp = h.moveRedRight();
            }
            if (tmp == h && cmp == 0) {
                h.key = this.min(h.right).key;
                h.right = this.deleteMin(h.right);
                --this.size;
            } else {
                h = tmp;
                h.right = this.delete(h.right, key);
            }
        }
        return h.fixUp();
    }

    public LLRBTree() {
    }

    public LLRBTree(Comparator<E> comparator) {
        this.providedComparator = comparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMax() {
        this.lock.writeLock().lock();
        try {
            if (this.root == null) {
                return;
            }
            this.root = this.deleteMax(this.root);
            if (this.root != null) {
                this.root.color = false;
            }
            --this.size;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMin() {
        this.lock.writeLock().lock();
        try {
            if (this.root == null) {
                return;
            }
            this.root = this.deleteMin(this.root);
            if (this.root != null) {
                this.root.color = false;
            }
            --this.size;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    public boolean isEmtpy() {
        return this.size == 0;
    }

    @Override
    public Comparator<E> comparator() {
        return this.providedComparator;
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        this.root = null;
        this.size = 0;
        this.lock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object key) {
        this.lock.readLock().lock();
        try {
            Comparable ckey;
            Node<E> current = this.root;
            Comparable comparable = ckey = this.providedComparator == null ? (Comparable)key : null;
            while (current != null) {
                int cmp;
                int n = cmp = ckey != null ? ckey.compareTo(current.key) : this.providedComparator.compare(key, current.key);
                if (cmp == 0) {
                    boolean bl = true;
                    return bl;
                }
                if (cmp < 0) {
                    current = current.left;
                    continue;
                }
                current = current.right;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E key) {
        this.lock.writeLock().lock();
        try {
            int s = this.size;
            this.root = this.insert(this.root, key);
            this.root.color = false;
            boolean bl = s != this.size;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key) {
        this.lock.writeLock().lock();
        try {
            if (this.root == null) {
                boolean bl = false;
                return bl;
            }
            int s = this.size;
            this.root = this.delete(this.root, key);
            if (this.root != null) {
                this.root.color = false;
            }
            boolean bl = s != this.size;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E first() {
        this.lock.readLock().lock();
        try {
            if (this.root == null) {
                E e = null;
                return e;
            }
            Object e = this.min(this.root).key;
            return e;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E last() {
        this.lock.readLock().lock();
        try {
            if (this.root == null) {
                E e = null;
                return e;
            }
            Object e = this.max(this.root).key;
            return e;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        throw new UnsupportedOperationException("...because of lazy implementor: this is a TODO.");
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        throw new UnsupportedOperationException("...because of lazy implementor: this is a TODO.");
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        throw new UnsupportedOperationException("...because of lazy implementor: this is a TODO.");
    }

    @Override
    public Iterator<E> iterator() {
        if (this.isEmpty()) {
            return HGSearchResult.EMPTY;
        }
        return new ResultSet(false);
    }

    @Override
    public HGRandomAccessResult<E> getSearchResult() {
        return new ResultSet(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() throws CloneNotSupportedException {
        this.lock.readLock().lock();
        try {
            LLRBTree cl = (LLRBTree)super.clone();
            cl.root = this.root == null ? this.root : this.root.clone();
            cl.size = this.size;
            LLRBTree lLRBTree = cl;
            return lLRBTree;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int depth() {
        this.lock.readLock().lock();
        try {
            int n = this.depth(this.root);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private int depth(Node<E> x) {
        if (x == null) {
            return 0;
        }
        return Math.max(1 + this.depth(x.left), 1 + this.depth(x.right));
    }

    public boolean check() {
        return this.isBST() && this.is234() && this.isBalanced();
    }

    public boolean isBST() {
        return this.isBST(this.root, this.first(), this.last());
    }

    private boolean isBST(Node<E> x, E min, E max) {
        int c2;
        if (x == null) {
            return true;
        }
        int c1 = this.providedComparator != null ? this.providedComparator.compare(x.key, min) : ((Comparable)x.key).compareTo(min);
        int n = c2 = this.providedComparator != null ? this.providedComparator.compare(max, x.key) : ((Comparable)max).compareTo(x.key);
        if (c1 < 0 || c2 < 0) {
            return false;
        }
        return this.isBST(x.left, min, x.key) && this.isBST(x.right, x.key, max);
    }

    public boolean is234() {
        return this.is234(this.root);
    }

    boolean is234(Node<E> x) {
        if (x == null) {
            return true;
        }
        if (LLRBTree.isRightLeaning(x)) {
            System.err.println("Right leaning node");
            return false;
        }
        if (LLRBTree.isRed(x) && LLRBTree.isRed(x.left)) {
            System.err.println("2 consecutive reds");
            return false;
        }
        return this.is234(x.left) && this.is234(x.right);
    }

    public boolean isBalanced() {
        return this.isBalanced(this.root);
    }

    public boolean isBalanced(Node<E> r) {
        int black = 0;
        Node<E> x = r;
        while (x != null) {
            if (!LLRBTree.isRed(x)) {
                ++black;
            }
            x = x.left;
        }
        return this.isBalanced(r, black);
    }

    private boolean isBalanced(Node<E> x, int black) {
        if (x == null && black == 0) {
            return true;
        }
        if (x == null && black != 0) {
            return false;
        }
        if (!LLRBTree.isRed(x)) {
            --black;
        }
        return this.isBalanced(x.left, black) && this.isBalanced(x.right, black);
    }

    final class ResultSet
    implements HGRandomAccessResult<E> {
        boolean locked = false;
        int lookahead = 0;
        Node<E> next = LLRBTree.access$300(LLRBTree.this);
        Node<E> current = LLRBTree.access$300(LLRBTree.this);
        Node<E> prev = LLRBTree.access$300(LLRBTree.this);
        NodeStack stack = new NodeStack();

        Node<E> min() {
            Node result = this.stack.top();
            while (result.left != null) {
                result = this.stack.push(result.left);
            }
            return result;
        }

        Node<E> max() {
            Node result = this.stack.top();
            while (result.right != null) {
                result = this.stack.push(result.right);
            }
            return result;
        }

        Node<E> advance() {
            Node current = this.stack.top();
            if (current.right != null) {
                this.stack.push(current.right);
                return this.min();
            }
            this.stack.backup();
            this.stack.pop();
            while (!this.stack.isEmpty()) {
                Node parent = this.stack.top();
                if (parent.left == current) {
                    return parent;
                }
                current = this.stack.pop();
            }
            this.stack.restore();
            return null;
        }

        Node<E> back() {
            Node current = this.stack.top();
            if (current.left != null) {
                this.stack.push(current.left);
                return this.max();
            }
            this.stack.backup();
            this.stack.pop();
            while (!this.stack.isEmpty()) {
                Node parent = this.stack.top();
                if (parent.right == current) {
                    return parent;
                }
                current = this.stack.pop();
            }
            this.stack.restore();
            return null;
        }

        ResultSet(boolean acquireLock) {
            if (acquireLock) {
                LLRBTree.this.lock.readLock().lock();
            }
            this.locked = acquireLock;
        }

        @Override
        public void goBeforeFirst() {
            this.lookahead = 0;
            this.current = this.prev = LLRBTree.this.UNKNOWN;
            this.next = this.prev;
            this.stack.clear();
        }

        @Override
        public void goAfterLast() {
            this.lookahead = 0;
            this.stack.clear();
            this.stack.push(LLRBTree.this.root);
            this.prev = this.max();
            this.next = this.current = LLRBTree.this.UNKNOWN;
        }

        @Override
        public HGRandomAccessResult.GotoResult goTo(E key, boolean exactMatch) {
            Comparable ckey;
            this.stack.backup();
            this.stack.clear();
            Node current = LLRBTree.this.root;
            HGRandomAccessResult.GotoResult result = HGRandomAccessResult.GotoResult.nothing;
            Comparable comparable = ckey = LLRBTree.this.providedComparator == null ? (Comparable)key : null;
            while (current != null) {
                int cmp;
                this.stack.push(current);
                int n = cmp = ckey == null ? LLRBTree.this.providedComparator.compare(key, current.key) : ckey.compareTo(current.key);
                if (cmp == 0) {
                    result = HGRandomAccessResult.GotoResult.found;
                    break;
                }
                if (cmp < 0) {
                    if (exactMatch || current.left != null) {
                        current = current.left;
                        continue;
                    }
                    result = HGRandomAccessResult.GotoResult.close;
                    break;
                }
                if (exactMatch || current.right != null) {
                    current = current.right;
                    continue;
                }
                if (this.advance() == null) break;
                result = HGRandomAccessResult.GotoResult.close;
                break;
            }
            if (HGRandomAccessResult.GotoResult.nothing == result) {
                this.stack.restore();
                return HGRandomAccessResult.GotoResult.nothing;
            }
            this.lookahead = 0;
            this.next = LLRBTree.this.UNKNOWN;
            this.prev = LLRBTree.this.UNKNOWN;
            this.current = this.stack.top();
            return result;
        }

        @Override
        public void close() {
            if (this.locked) {
                LLRBTree.this.lock.readLock().unlock();
            }
        }

        @Override
        public E current() {
            if (this.current == LLRBTree.this.UNKNOWN) {
                throw new NoSuchElementException();
            }
            return this.current.key;
        }

        @Override
        public boolean isOrdered() {
            return true;
        }

        @Override
        public boolean hasNext() {
            if (this.next == LLRBTree.this.UNKNOWN) {
                this.moveNext();
            }
            return this.next != null;
        }

        private void moveNext() {
            if (this.stack.isEmpty()) {
                this.stack.push(LLRBTree.this.root);
                this.next = this.min();
                this.lookahead = 1;
            } else {
                do {
                    this.next = this.advance();
                } while (this.next != null && ++this.lookahead != 1);
            }
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.prev = this.current;
            this.current = this.next;
            --this.lookahead;
            this.moveNext();
            return this.current.key;
        }

        @Override
        public void remove() {
            if (this.current == LLRBTree.this.UNKNOWN) {
                throw new NoSuchElementException();
            }
            LLRBTree.this.remove(this.current.key);
            if (this.prev != null) {
                if (this.goTo((E)this.prev.key, true) == HGRandomAccessResult.GotoResult.nothing) {
                    throw new Error("LLRBTree.ResultSet.remove buggy.");
                }
                this.prev = this.next = LLRBTree.this.UNKNOWN;
                this.current = this.next;
                this.lookahead = 0;
                this.stack.clear();
            }
        }

        @Override
        public boolean hasPrev() {
            if (this.prev == LLRBTree.this.UNKNOWN) {
                this.movePrev();
            }
            return this.prev != null;
        }

        private void movePrev() {
            if (this.stack.isEmpty()) {
                this.prev = null;
            } else {
                do {
                    this.prev = this.back();
                } while (this.prev != null && --this.lookahead != -1);
            }
        }

        @Override
        public E prev() {
            if (this.prev == null) {
                throw new NoSuchElementException();
            }
            this.next = this.current;
            this.current = this.prev;
            ++this.lookahead;
            this.movePrev();
            return this.current.key;
        }
    }

    private static class Node<E>
    implements Cloneable {
        E key;
        Node<E> left;
        Node<E> right;
        boolean color;

        public Node<E> clone() throws CloneNotSupportedException {
            Node n = (Node)super.clone();
            if (this.left != null) {
                n.left = this.left.clone();
            }
            if (this.right != null) {
                n.right = this.right.clone();
            }
            return n;
        }

        Node(E key, boolean color) {
            this.key = key;
            this.color = color;
        }

        Node<E> rotateLeft() {
            Node<E> x = this.right;
            this.right = x.left;
            x.left = this;
            x.color = this.color;
            this.color = true;
            return x;
        }

        Node<E> rotateRight() {
            Node<E> x = this.left;
            this.left = x.right;
            x.right = this;
            x.color = this.color;
            this.color = true;
            return x;
        }

        Node<E> colorFlip() {
            this.color = !this.color;
            this.left.color = !this.left.color;
            this.right.color = !this.right.color;
            return this;
        }

        private Node<E> fixUp() {
            Node<E> h = this;
            if (LLRBTree.isRed(h.right)) {
                h = h.rotateLeft();
                if (LLRBTree.isRightLeaning(h.left)) {
                    h.left = h.left.rotateLeft();
                }
            }
            if (LLRBTree.isRed(h.left) && LLRBTree.isRed(h.left.left)) {
                h = h.rotateRight();
            }
            if (LLRBTree.isRed(h.left) && LLRBTree.isRed(h.right)) {
                h.colorFlip();
            }
            return h;
        }

        private Node<E> moveRedRight() {
            this.colorFlip();
            if (LLRBTree.isRed(this.left.left)) {
                Node<E> h = this.rotateRight();
                return h.colorFlip();
            }
            return this;
        }

        private Node<E> moveRedLeft() {
            this.colorFlip();
            if (LLRBTree.isRed(this.right.left)) {
                this.right = this.right.rotateRight();
                Node<E> h = this.rotateLeft();
                if (LLRBTree.isRightLeaning(h.right)) {
                    h.right = h.right.rotateLeft();
                }
                return h.colorFlip();
            }
            return this;
        }
    }

    private final class NodeStack {
        Node<E>[] A;
        Node<E>[] B;
        int pos = -1;
        int bpos;

        NodeStack() {
            int s = 0;
            if (LLRBTree.this.size > 0) {
                s = (int)(2.0 * (Math.log(LLRBTree.this.size + 1) / Math.log(2.0)));
            }
            this.A = new Node[s];
            this.B = new Node[s];
        }

        void backup() {
            this.bpos = this.pos;
            System.arraycopy(this.A, 0, this.B, 0, this.pos + 1);
        }

        void restore() {
            this.pos = this.bpos;
            Node<E>[] tmp = this.A;
            this.A = this.B;
            this.B = tmp;
        }

        boolean isEmpty() {
            return this.pos < 0;
        }

        Node<E> top() {
            return this.A[this.pos];
        }

        Node<E> pop() {
            return this.A[this.pos--];
        }

        Node<E> push(Node<E> n) {
            Node node = n;
            this.A[++this.pos] = node;
            return node;
        }

        void clear() {
            this.pos = -1;
        }
    }
}

