/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.util;

import com.sleepycat.db.DeadlockException;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.hypergraphdb.HGEnvironment;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGLink;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HGQuery;
import org.hypergraphdb.HGRandomAccessResult;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.transaction.TransactionConflictException;
import org.hypergraphdb.util.Mapping;

public class HGUtils {
    public static final HGPersistentHandle[] EMPTY_HANDLE_ARRAY = new HGPersistentHandle[0];

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static void throwRuntimeException(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new HGException(t);
    }

    public static Throwable getRootCause(Throwable t) {
        if (t != null) {
            while (t.getCause() != null) {
                t = t.getCause();
            }
        }
        return t;
    }

    public static boolean eq(Object left, Object right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return false;
        }
        if (right == null) {
            return false;
        }
        return left.equals(right);
    }

    public static boolean eq(Object[] left, Object[] right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.length != right.length) {
            return false;
        }
        for (int i = 0; i < left.length; ++i) {
            if (HGUtils.eq(left[i], right[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean eq(byte[] left, byte[] right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null || left.length != right.length) {
            return false;
        }
        for (int i = 0; i < left.length; ++i) {
            if (left[i] == right[i]) continue;
            return false;
        }
        return true;
    }

    public static int hashIt(Object o) {
        if (o == null) {
            return 0;
        }
        return o.hashCode();
    }

    public static int hashThem(Object one, Object two) {
        return HGUtils.hashIt(one) | HGUtils.hashIt(two);
    }

    public static String printStackTrace(Throwable t) {
        StringWriter strWriter = new StringWriter();
        PrintWriter prWriter = new PrintWriter(strWriter);
        t.printStackTrace(prWriter);
        prWriter.flush();
        return strWriter.toString();
    }

    public static void printStackTrace(StackTraceElement[] trace, PrintStream out) {
        for (StackTraceElement el : trace) {
            out.println(el.toString());
        }
    }

    public static void logCallStack(PrintStream out) {
        HGUtils.printStackTrace(Thread.currentThread().getStackTrace(), out);
    }

    public static void closeNoException(HGSearchResult<?> rs) {
        if (rs == null) {
            return;
        }
        try {
            rs.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void wrapAndRethrow(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new HGException(t);
    }

    public static <T> Class<T> loadClass(HyperGraph graph, String classname) throws ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            return loader.loadClass(classname);
        }
        catch (Throwable ex) {
            loader = graph.getTypeSystem().getClassLoader();
            if (loader == null) {
                loader = HGUtils.class.getClassLoader();
            }
            return loader.loadClass(classname);
        }
    }

    public static HGHandle[] toHandleArray(HGLink link) {
        if (link == null) {
            return null;
        }
        HGHandle[] A = new HGHandle[link.getArity()];
        for (int i = 0; i < link.getArity(); ++i) {
            A[i] = link.getTargetAt(i);
        }
        return A;
    }

    public static <T> long queryBatchProcess(HGQuery<T> query, Mapping<T, Boolean> F2, int batchSize, T startAfter, long first) {
        HGSearchResult<T> rs = null;
        T lastProcessed = startAfter;
        long totalProcessed = 0L;
        while (true) {
            T txLastProcessed = lastProcessed;
            int currentProcessed = 0;
            query.getHyperGraph().getTransactionManager().beginTransaction();
            try {
                int i;
                rs = query.execute();
                if (txLastProcessed == null) {
                    for (long i2 = first; i2 > 0L; --i2) {
                        if (!rs.hasNext()) {
                            rs.close();
                            rs = null;
                            query.getHyperGraph().getTransactionManager().endTransaction(false);
                            long l = totalProcessed;
                            return l;
                        }
                        rs.next();
                    }
                } else {
                    HGRandomAccessResult.GotoResult gt = null;
                    if (!(rs instanceof HGRandomAccessResult)) {
                        rs.close();
                        rs = null;
                        throw new HGException("Batch processing starting at a specific element is only supported for HGRandomAccessResult.");
                    }
                    HGRandomAccessResult rars2 = (HGRandomAccessResult)rs;
                    gt = rars2.goTo(txLastProcessed, false);
                    if (gt == HGRandomAccessResult.GotoResult.nothing) {
                        rs.close();
                        rs = null;
                        query.getHyperGraph().getTransactionManager().endTransaction(false);
                        long rars2 = totalProcessed;
                        return rars2;
                    }
                    if (gt == HGRandomAccessResult.GotoResult.found) {
                        if (!rs.hasNext()) {
                            rs.close();
                            rs = null;
                            query.getHyperGraph().getTransactionManager().endTransaction(false);
                            long rars2 = totalProcessed;
                            return rars2;
                        }
                        rs.next();
                    }
                }
                if (!(rs instanceof HGRandomAccessResult)) {
                    batchSize = Integer.MAX_VALUE;
                }
                for (i = 0; i < batchSize; ++i) {
                    T x = rs.current();
                    if (!F2.eval(x).booleanValue()) {
                        rs.close();
                        rs = null;
                        query.getHyperGraph().getTransactionManager().endTransaction(true);
                        long l = totalProcessed + (long)currentProcessed;
                        return l;
                    }
                    txLastProcessed = x;
                    ++currentProcessed;
                    if (!rs.hasNext()) break;
                    rs.next();
                }
                rs.close();
                rs = null;
                query.getHyperGraph().getTransactionManager().endTransaction(true);
                lastProcessed = txLastProcessed;
                totalProcessed += (long)currentProcessed;
                if (i >= batchSize) continue;
                long x = totalProcessed;
                return x;
            }
            catch (Throwable t) {
                Throwable cause = HGUtils.getRootCause(t);
                if (cause instanceof TransactionConflictException || cause instanceof DeadlockException) continue;
                try {
                    query.getHyperGraph().getTransactionManager().endTransaction(false);
                }
                catch (Throwable tt) {
                    tt.printStackTrace(System.err);
                }
                throw new RuntimeException(t);
            }
            finally {
                HGUtils.closeNoException(rs);
                continue;
            }
            break;
        }
    }

    public static void directoryRecurse(File top, Mapping<File, Boolean> mapping) {
        File[] subs = top.listFiles();
        if (subs != null) {
            for (File sub : subs) {
                if (sub.isDirectory()) {
                    HGUtils.directoryRecurse(sub, mapping);
                }
                mapping.eval(sub);
            }
            mapping.eval(top);
        }
    }

    public static void dropHyperGraphInstance(String location) {
        if (HGEnvironment.isOpen(location)) {
            HGEnvironment.get(location).close();
        }
        HGUtils.directoryRecurse(new File(location), new Mapping<File, Boolean>(){

            @Override
            public Boolean eval(File f) {
                return f.delete();
            }
        });
    }

    public static <T> Class<T> getImplementationClass(String interfaceClassName, String defaultImplementation) {
        try {
            String className = System.getProperty(interfaceClassName);
            if (className == null) {
                className = defaultImplementation;
            }
            return Class.forName(className);
        }
        catch (Exception ex) {
            throw new HGException(ex);
        }
    }

    public static <T> T getImplementationOf(String interfaceClassName, String defaultImplementation) {
        Class<T> cl = HGUtils.getImplementationClass(interfaceClassName, defaultImplementation);
        try {
            return cl.newInstance();
        }
        catch (Exception e) {
            throw new HGException(e);
        }
    }
}

