/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.util;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.transaction.BDBTxLock;
import org.hypergraphdb.transaction.HGTransaction;
import org.hypergraphdb.transaction.TransactionBDBImpl;

public class HGLock
implements ReadWriteLock {
    private ReentrantReadWriteLock defaultLock = null;
    private BDBTxLock txLock = null;

    ReadWriteLock getApplicableLock() {
        HGTransaction tx = this.txLock.getGraph().getTransactionManager().getContext().getCurrent();
        if (tx == null || !(tx.getStorageTransaction() instanceof TransactionBDBImpl)) {
            if (this.defaultLock == null) {
                this.defaultLock = new ReentrantReadWriteLock();
            }
            return this.defaultLock;
        }
        return this.txLock;
    }

    public HGLock(HyperGraph graph, byte[] objectId) {
        this.txLock = new BDBTxLock(graph, objectId);
    }

    @Override
    public Lock readLock() {
        return this.getApplicableLock().readLock();
    }

    @Override
    public Lock writeLock() {
        return this.getApplicableLock().writeLock();
    }
}

