/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.util;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hypergraphdb.util.Mapping;

public class CallbackFuture<T>
implements Future<T> {
    private CountDownLatch latch = new CountDownLatch(1);
    private T result;
    private Mapping<CallbackFuture<T>, T> listener;
    protected volatile boolean canceled = false;

    public synchronized void setCompletionListener(Mapping<CallbackFuture<T>, T> listener) {
        this.listener = listener;
    }

    public synchronized void complete(T result) {
        if (this.isDone()) {
            throw new IllegalStateException("JobFuture completion attempted after it was done.");
        }
        this.result = result;
        this.latch.countDown();
        if (this.listener != null) {
            result = this.listener.eval(this);
        }
    }

    public T getResult() {
        return this.result;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.latch.await();
        return this.result;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.latch.await(timeout, unit)) {
            return this.result;
        }
        return null;
    }

    @Override
    public boolean isCancelled() {
        return this.canceled;
    }

    @Override
    public boolean isDone() {
        return this.latch.getCount() == 0L && !this.canceled;
    }
}

