/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class AggregateFuture<T>
implements Future<List<T>> {
    private List<Future<T>> components = new ArrayList<Future<T>>();

    public AggregateFuture(List<Future<T>> components) {
        this.components.addAll(components);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        for (Future<T> f : this.components) {
            if (f.cancel(mayInterruptIfRunning)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<T> get() throws InterruptedException, ExecutionException {
        ArrayList<T> value = new ArrayList<T>();
        for (Future<T> f : this.components) {
            value.add(f.get());
        }
        return value;
    }

    @Override
    public List<T> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ArrayList<T> value = new ArrayList<T>();
        for (Future<T> f : this.components) {
            value.add(f.get(timeout, unit));
        }
        return value;
    }

    @Override
    public boolean isCancelled() {
        for (Future<T> f : this.components) {
            if (!f.isCancelled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDone() {
        for (Future<T> f : this.components) {
            if (f.isDone()) continue;
            return false;
        }
        return true;
    }
}

