/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type.javaprimitive;

import java.util.Comparator;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGOrderedSearchable;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.HGSortIndex;
import org.hypergraphdb.HGStore;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.IncidenceSetRef;
import org.hypergraphdb.LazyRef;
import org.hypergraphdb.storage.BAUtils;
import org.hypergraphdb.storage.BAtoBA;
import org.hypergraphdb.storage.BAtoHandle;
import org.hypergraphdb.type.HGPrimitiveType;
import org.hypergraphdb.type.HGRefCountedType;

public abstract class PrimitiveTypeBase<JavaType>
implements HGPrimitiveType<JavaType>,
HGOrderedSearchable<JavaType, HGPersistentHandle>,
Comparator<byte[]>,
HGRefCountedType {
    protected HyperGraph graph = null;
    protected HGSortIndex<byte[], HGPersistentHandle> valueIndex = null;
    protected static final int dataOffset = 4;

    protected abstract String getIndexName();

    protected final HGSortIndex<byte[], HGPersistentHandle> getIndex() {
        if (this.valueIndex == null) {
            Comparator<byte[]> comparator = this.getComparator();
            this.valueIndex = (HGSortIndex)this.graph.getStore().getIndex(this.getIndexName(), BAtoBA.getInstance(), BAtoHandle.getInstance(this.graph.getHandleFactory()), comparator, true);
        }
        return this.valueIndex;
    }

    protected final int getRefCount(byte[] buf) {
        return BAUtils.readInt(buf, 0);
    }

    protected final void putRefCount(int c, byte[] buf) {
        BAUtils.writeInt(c, buf, 0);
    }

    protected final HGPersistentHandle storeImpl(byte[] data) {
        HGStore store = this.graph.getStore();
        HGPersistentHandle handle = null;
        HGSortIndex<byte[], HGPersistentHandle> idx = this.getIndex();
        handle = (HGPersistentHandle)idx.findFirst(data);
        if (handle == null) {
            handle = this.graph.getHandleFactory().makeHandle();
            this.putRefCount(1, data);
            store.store(handle, data);
            idx.addEntry(data, handle);
        } else {
            byte[] ref_counted_data = store.getData(handle);
            this.putRefCount(this.getRefCount(ref_counted_data) + 1, ref_counted_data);
            store.store(handle, ref_counted_data);
        }
        return handle;
    }

    protected abstract byte[] writeBytes(JavaType var1);

    protected abstract JavaType readBytes(byte[] var1, int var2);

    @Override
    public int compare(byte[] left, byte[] right) {
        return this.getComparator().compare(left, right);
    }

    @Override
    public final void setHyperGraph(HyperGraph hg2) {
        this.graph = hg2;
    }

    @Override
    public final void release(HGPersistentHandle handle) {
        HGStore store = this.graph.getStore();
        byte[] ref_counted_data = store.getData(handle);
        int refCnt = this.getRefCount(ref_counted_data);
        if (--refCnt > 0) {
            this.putRefCount(refCnt, ref_counted_data);
            store.store(handle, ref_counted_data);
        } else {
            store.removeData(handle);
            this.getIndex().removeEntry(ref_counted_data, handle);
        }
    }

    @Override
    public Object make(HGPersistentHandle handle, LazyRef<HGHandle[]> targetSet, IncidenceSetRef incidenceSet) {
        byte[] asBytes = this.graph.getStore().getData(handle);
        if (asBytes == null) {
            throw new HGException("Could not find data for handle: " + handle.toString());
        }
        return this.readBytes(asBytes, 4);
    }

    private byte[] objectAsBytes(JavaType instance) {
        byte[] data = this.writeBytes(instance);
        byte[] full = new byte[4 + data.length];
        System.arraycopy(data, 0, full, 4, data.length);
        return full;
    }

    @Override
    public JavaType fromByteArray(byte[] byteArray) {
        return this.readBytes(byteArray, 4);
    }

    @Override
    public byte[] toByteArray(JavaType object) {
        return this.objectAsBytes(object);
    }

    @Override
    public HGPersistentHandle store(Object instance) {
        return this.storeImpl(this.objectAsBytes(instance));
    }

    @Override
    public HGSearchResult<HGPersistentHandle> find(JavaType key) {
        return this.getIndex().find(this.objectAsBytes(key));
    }

    @Override
    public HGSearchResult<HGPersistentHandle> findGT(JavaType key) {
        return this.getIndex().findGT(this.objectAsBytes(key));
    }

    @Override
    public HGSearchResult<HGPersistentHandle> findGTE(JavaType key) {
        return this.getIndex().findGTE(this.objectAsBytes(key));
    }

    @Override
    public HGSearchResult<HGPersistentHandle> findLT(JavaType key) {
        return this.getIndex().findLT(this.objectAsBytes(key));
    }

    @Override
    public HGSearchResult<HGPersistentHandle> findLTE(JavaType key) {
        return this.getIndex().findLTE(this.objectAsBytes(key));
    }

    @Override
    public boolean subsumes(Object l, Object r) {
        if (l == null || r == null) {
            return l == null;
        }
        return l.equals(r);
    }

    public int getRefCountFor(JavaType o) {
        byte[] B = this.objectAsBytes(o);
        HGPersistentHandle handle = (HGPersistentHandle)this.getIndex().findFirst(B);
        if (handle == null) {
            return 0;
        }
        byte[] ref_counted_data = this.graph.getStore().getData(handle);
        int refCnt = this.getRefCount(ref_counted_data);
        return refCnt;
    }
}

