/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type.javaprimitive;

import org.hypergraphdb.type.javaprimitive.NumericTypeBase;

public class LongType
extends NumericTypeBase<Long> {
    public static final String INDEX_NAME = "hg_long_value_index";

    @Override
    protected String getIndexName() {
        return INDEX_NAME;
    }

    @Override
    protected byte[] writeBytes(Long value) {
        byte[] data = new byte[8];
        long v = value;
        data[0] = (byte)(v >>> 56);
        data[1] = (byte)(v >>> 48);
        data[2] = (byte)(v >>> 40);
        data[3] = (byte)(v >>> 32);
        data[4] = (byte)(v >>> 24);
        data[5] = (byte)(v >>> 16);
        data[6] = (byte)(v >>> 8);
        data[7] = (byte)(v >>> 0);
        return data;
    }

    @Override
    protected Long readBytes(byte[] bytes, int offset) {
        return new Long(((long)bytes[offset] << 56) + ((long)(bytes[offset + 1] & 0xFF) << 48) + ((long)(bytes[offset + 2] & 0xFF) << 40) + ((long)(bytes[offset + 3] & 0xFF) << 32) + ((long)(bytes[offset + 4] & 0xFF) << 24) + (long)((bytes[offset + 5] & 0xFF) << 16) + (long)((bytes[offset + 6] & 0xFF) << 8) + (long)((bytes[offset + 7] & 0xFF) << 0));
    }
}

