/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type.javaprimitive;

import org.hypergraphdb.type.javaprimitive.NumericTypeBase;

public final class IntType
extends NumericTypeBase<Integer> {
    public static final String INDEX_NAME = "hg_int_value_index";

    @Override
    protected String getIndexName() {
        return INDEX_NAME;
    }

    @Override
    protected byte[] writeBytes(Integer value) {
        byte[] data = new byte[4];
        int v = value;
        data[0] = (byte)(v >>> 24 & 0xFF);
        data[1] = (byte)(v >>> 16 & 0xFF);
        data[2] = (byte)(v >>> 8 & 0xFF);
        data[3] = (byte)(v >>> 0 & 0xFF);
        return data;
    }

    @Override
    protected Integer readBytes(byte[] bytes, int offset) {
        byte ch1 = bytes[offset];
        byte ch2 = bytes[offset + 1];
        byte ch3 = bytes[offset + 2];
        byte ch4 = bytes[offset + 3];
        int i = (ch1 & 0xFF) << 24 | (ch2 & 0xFF) << 16 | (ch3 & 0xFF) << 8 | ch4 & 0xFF;
        return new Integer(i);
    }
}

