/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type.javaprimitive;

import java.util.Comparator;
import org.hypergraphdb.type.javaprimitive.PrimitiveTypeBase;

public class DoubleType
extends PrimitiveTypeBase<Double> {
    public static final String INDEX_NAME = "hg_double_value_index";
    private static final DoubleComparator comp = new DoubleComparator();

    @Override
    public Comparator<byte[]> getComparator() {
        return comp;
    }

    @Override
    protected String getIndexName() {
        return INDEX_NAME;
    }

    @Override
    protected byte[] writeBytes(Double value) {
        byte[] data = new byte[8];
        long v = Double.doubleToLongBits(value);
        data[0] = (byte)(v >>> 56);
        data[1] = (byte)(v >>> 48);
        data[2] = (byte)(v >>> 40);
        data[3] = (byte)(v >>> 32);
        data[4] = (byte)(v >>> 24);
        data[5] = (byte)(v >>> 16);
        data[6] = (byte)(v >>> 8);
        data[7] = (byte)(v >>> 0);
        return data;
    }

    @Override
    protected Double readBytes(byte[] bytes, int offset) {
        return new Double(DoubleType.bytesToDouble(bytes));
    }

    private static double bytesToDouble(byte[] bytes) {
        int l = bytes.length - 8;
        return Double.longBitsToDouble(((long)bytes[l] << 56) + ((long)(bytes[l + 1] & 0xFF) << 48) + ((long)(bytes[l + 2] & 0xFF) << 40) + ((long)(bytes[l + 3] & 0xFF) << 32) + ((long)(bytes[l + 4] & 0xFF) << 24) + (long)((bytes[l + 5] & 0xFF) << 16) + (long)((bytes[l + 6] & 0xFF) << 8) + (long)((bytes[l + 7] & 0xFF) << 0));
    }

    public static class DoubleComparator
    implements Comparator<byte[]> {
        @Override
        public int compare(byte[] left, byte[] right) {
            byte[] left_f = new byte[left.length - 4];
            System.arraycopy(left, 4, left_f, 0, left_f.length);
            byte[] right_f = new byte[right.length - 4];
            System.arraycopy(right, 4, right_f, 0, right_f.length);
            return Double.compare(DoubleType.bytesToDouble(left_f), DoubleType.bytesToDouble(right_f));
        }
    }
}

