/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type.javaprimitive;

import java.util.Comparator;
import org.hypergraphdb.type.javaprimitive.PrimitiveTypeBase;

public class BooleanType
extends PrimitiveTypeBase<Boolean> {
    public static final String INDEX_NAME = "hg_bool_value_index";
    private static final BoolComparator comp = new BoolComparator();

    @Override
    public Comparator<byte[]> getComparator() {
        return comp;
    }

    @Override
    protected String getIndexName() {
        return INDEX_NAME;
    }

    @Override
    protected Boolean readBytes(byte[] bytes, int offset) {
        return new Boolean(bytes[offset] == 1);
    }

    @Override
    protected byte[] writeBytes(Boolean value) {
        boolean b = value != false;
        return new byte[]{(byte)(b ? 1 : 0)};
    }

    public static class BoolComparator
    implements Comparator<byte[]> {
        @Override
        public int compare(byte[] left, byte[] right) {
            return left[4] - right[4];
        }
    }
}

