/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.algorithms.DefaultALGenerator;
import org.hypergraphdb.algorithms.HGDepthFirstTraversal;
import org.hypergraphdb.atom.HGSubsumes;
import org.hypergraphdb.query.AtomTypeCondition;
import org.hypergraphdb.query.TypePlusCondition;
import org.hypergraphdb.transaction.HGTransactionException;
import org.hypergraphdb.type.HGAtomType;
import org.hypergraphdb.type.HGCompositeType;
import org.hypergraphdb.type.HGProjection;
import org.hypergraphdb.type.HGRefCountedType;
import org.hypergraphdb.type.HGTypedValue;
import org.hypergraphdb.util.HGUtils;
import org.hypergraphdb.util.Pair;

public final class TypeUtils {
    private static ThreadLocal<Map<HGPersistentHandle, Object>> HANDLE_REF_MAP = new ThreadLocal();
    private static ThreadLocal<Map<Object, HGPersistentHandle>> JAVA_REF_MAP = new ThreadLocal();
    private static ThreadLocal<Set<HGPersistentHandle>> HANDLE_REF_SET = new ThreadLocal();

    public static String[] parseDimensionPath(String formatted) {
        StringTokenizer tok = new StringTokenizer(formatted, ".");
        String[] result = new String[tok.countTokens()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = tok.nextToken();
        }
        return result;
    }

    public static String formatDimensionPath(String[] dimPath) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < dimPath.length; ++i) {
            result.append(dimPath[i]);
            if (i >= dimPath.length - 1) continue;
            result.append(".");
        }
        return result.toString();
    }

    public static HGProjection getProjection(HyperGraph hg2, HGAtomType type, String[] dimPath) {
        HGProjection proj = null;
        for (int j = 0; j < dimPath.length; ++j) {
            if (!(type instanceof HGCompositeType)) {
                return null;
            }
            proj = ((HGCompositeType)type).getProjection(dimPath[j]);
            if (proj == null) {
                return null;
            }
            type = (HGAtomType)hg2.get(proj.getType());
        }
        return proj;
    }

    public static HGTypedValue project(HyperGraph hg2, HGHandle type, Object value, String[] dimPath, boolean throwExceptionOnNotFound) {
        for (int j = 0; j < dimPath.length; ++j) {
            HGAtomType tinstance = (HGAtomType)hg2.get(type);
            if (!(tinstance instanceof HGCompositeType)) {
                if (throwExceptionOnNotFound) {
                    throw new HGException("Only composite types can be indexed by value parts: " + value + ", during projection of " + TypeUtils.formatDimensionPath(dimPath) + " in type " + tinstance);
                }
                return null;
            }
            HGProjection proj = ((HGCompositeType)tinstance).getProjection(dimPath[j]);
            if (proj == null) {
                if (throwExceptionOnNotFound) {
                    throw new HGException("Dimension " + dimPath[j] + " does not exist in type " + tinstance);
                }
                return null;
            }
            value = proj.project(value);
            type = proj.getType();
        }
        return new HGTypedValue(value, type);
    }

    public static boolean initThreadLocals() {
        if (JAVA_REF_MAP.get() == null) {
            JAVA_REF_MAP.set(new IdentityHashMap());
            HANDLE_REF_MAP.set(new HashMap());
            HANDLE_REF_SET.set(new HashSet());
            return true;
        }
        return false;
    }

    public static void releaseThreadLocals(boolean topCall) {
        if (topCall) {
            JAVA_REF_MAP.set(null);
            HANDLE_REF_MAP.set(null);
            HANDLE_REF_SET.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HGPersistentHandle getNewHandleFor(HyperGraph hg2, Object value) {
        boolean topCall = TypeUtils.initThreadLocals();
        try {
            HGPersistentHandle result = hg2.getHandleFactory().makeHandle();
            if (value instanceof WrappedRuntimeInstance) {
                value = ((WrappedRuntimeInstance)value).getRealInstance();
            }
            JAVA_REF_MAP.get().put(value, result);
            HGPersistentHandle hGPersistentHandle = result;
            return hGPersistentHandle;
        }
        finally {
            TypeUtils.releaseThreadLocals(topCall);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValueReleased(HyperGraph graph, HGPersistentHandle h) {
        boolean topCall = TypeUtils.initThreadLocals();
        try {
            boolean bl = HANDLE_REF_SET.get().contains(h);
            return bl;
        }
        finally {
            TypeUtils.releaseThreadLocals(topCall);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseValue(HyperGraph graph, HGAtomType type, HGPersistentHandle h) {
        boolean topCall = TypeUtils.initThreadLocals();
        try {
            Object instance = HANDLE_REF_MAP.get().remove(h);
            if (instance != null) {
                JAVA_REF_MAP.get().remove(instance);
            }
            if (!(type instanceof HGRefCountedType)) {
                HANDLE_REF_SET.get().add(h);
            }
        }
        finally {
            TypeUtils.releaseThreadLocals(topCall);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HGPersistentHandle storeValue(HyperGraph graph, Object value, HGAtomType type) {
        boolean topCall = TypeUtils.initThreadLocals();
        try {
            HGPersistentHandle result = null;
            if (!(type instanceof HGRefCountedType)) {
                result = JAVA_REF_MAP.get().get(value);
            }
            if (result == null) {
                result = type.store(value);
                JAVA_REF_MAP.get().put(value, result);
            }
            HANDLE_REF_MAP.get().put(result, value);
            HGPersistentHandle hGPersistentHandle = result;
            return hGPersistentHandle;
        }
        finally {
            TypeUtils.releaseThreadLocals(topCall);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HGPersistentHandle getHandleFor(HyperGraph graph, Object value) {
        boolean topCall = TypeUtils.initThreadLocals();
        try {
            HGPersistentHandle hGPersistentHandle = JAVA_REF_MAP.get().get(value);
            return hGPersistentHandle;
        }
        finally {
            TypeUtils.releaseThreadLocals(topCall);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setValueFor(HyperGraph graph, HGPersistentHandle h, Object value) {
        boolean topCall = TypeUtils.initThreadLocals();
        try {
            Map<HGPersistentHandle, Object> refMap = HANDLE_REF_MAP.get();
            if (!refMap.containsKey(h)) {
                refMap.put(h, value);
            }
        }
        finally {
            TypeUtils.releaseThreadLocals(topCall);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object makeValue(HyperGraph graph, HGPersistentHandle h, HGAtomType type) {
        boolean topCall = TypeUtils.initThreadLocals();
        try {
            Map<HGPersistentHandle, Object> refMap = HANDLE_REF_MAP.get();
            Object result = refMap.get(h);
            if (result == null) {
                result = type.make(h, null, null);
                refMap.put(h, result);
            }
            Object object = result;
            return object;
        }
        finally {
            TypeUtils.releaseThreadLocals(topCall);
        }
    }

    public static List<HGHandle> subsumesClosure(HyperGraph graph, HGHandle baseType) {
        DefaultALGenerator alGenerator = new DefaultALGenerator(graph, new AtomTypeCondition(HGSubsumes.class), null, false, true, false);
        HGDepthFirstTraversal traversal = new HGDepthFirstTraversal(baseType, alGenerator);
        ArrayList<HGHandle> subTypes = new ArrayList<HGHandle>();
        while (traversal.hasNext()) {
            subTypes.add((HGHandle)((Pair)traversal.next()).getSecond());
        }
        subTypes.add(baseType);
        return subTypes;
    }

    public static boolean deleteType(HyperGraph graph, HGHandle th, boolean recursive) {
        if (recursive) {
            List<HGHandle> L = TypeUtils.subsumesClosure(graph, th);
            for (HGHandle h : L) {
                if (TypeUtils.deleteType(graph, h)) continue;
                return false;
            }
            return true;
        }
        return TypeUtils.deleteType(graph, th);
    }

    public static boolean deleteType(HyperGraph graph, Class<?> type, boolean recursive) {
        HGHandle th = graph.getTypeSystem().getTypeHandleIfDefined(type);
        if (th == null) {
            return true;
        }
        return TypeUtils.deleteType(graph, th, recursive);
    }

    public static boolean deleteType(HyperGraph graph, HGHandle type) {
        if (TypeUtils.deleteInstances(graph, type)) {
            return graph.remove(type);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteInstances(HyperGraph graph, HGHandle type) {
        int batchSize = 100;
        HGHandle[] batch = new HGHandle[batchSize];
        boolean done = false;
        while (!done) {
            HGSearchResult rs = null;
            try {
                int fetched = 0;
                graph.getTransactionManager().beginTransaction();
                try {
                    rs = graph.find(new TypePlusCondition(type));
                    while (fetched < batch.length && rs.hasNext()) {
                        batch[fetched++] = (HGHandle)rs.next();
                    }
                    rs.close();
                }
                finally {
                    try {
                        graph.getTransactionManager().endTransaction(true);
                    }
                    catch (HGTransactionException tex) {
                        throw new HGException(tex);
                    }
                }
                done = fetched == 0;
                graph.getTransactionManager().beginTransaction();
                while (--fetched >= 0) {
                    if (graph.remove(batch[fetched])) continue;
                    boolean tex = false;
                    return tex;
                }
                try {
                    graph.getTransactionManager().endTransaction(true);
                }
                catch (Throwable t) {
                    try {
                        graph.getTransactionManager().endTransaction(false);
                    }
                    catch (Throwable t1) {
                        t1.printStackTrace(System.err);
                    }
                    done = false;
                    HGUtils.wrapAndRethrow(t);
                }
            }
            finally {
                HGUtils.closeNoException(rs);
            }
        }
        return true;
    }

    public static interface WrappedRuntimeInstance {
        public Object getRealInstance();
    }
}

