/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.IncidenceSetRef;
import org.hypergraphdb.LazyRef;
import org.hypergraphdb.type.HGAtomType;

public class SerializableType
implements HGAtomType {
    private HyperGraph hg;

    @Override
    public void setHyperGraph(HyperGraph hg2) {
        this.hg = hg2;
    }

    @Override
    public Object make(HGPersistentHandle handle, LazyRef<HGHandle[]> targetSet, IncidenceSetRef incidenceSet) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(this.hg.getStore().getData(handle));
            SerInputStream objectIn = new SerInputStream(in, this.hg);
            return objectIn.readObject();
        }
        catch (Exception ex) {
            throw new HGException(ex);
        }
    }

    @Override
    public void release(HGPersistentHandle handle) {
        this.hg.getStore().removeData(handle);
    }

    @Override
    public HGPersistentHandle store(Object instance) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream objectOut = new ObjectOutputStream(out);
            objectOut.writeObject(instance);
            objectOut.flush();
            return this.hg.getStore().store(out.toByteArray());
        }
        catch (IOException ex) {
            throw new HGException(ex);
        }
    }

    @Override
    public boolean subsumes(Object general, Object specific) {
        return false;
    }

    public static class SerInputStream
    extends ObjectInputStream {
        private HyperGraph graph;

        public SerInputStream() throws IOException {
        }

        public SerInputStream(HyperGraph graph) throws IOException {
            this.graph = graph;
        }

        public SerInputStream(InputStream in, HyperGraph graph) throws IOException {
            super(in);
            this.graph = graph;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            try {
                return super.resolveClass(desc);
            }
            catch (Exception ex) {
                ClassLoader cl;
                ClassLoader classLoader = cl = this.graph == null ? null : this.graph.getTypeSystem().getClassLoader();
                if (cl == null) {
                    cl = Thread.currentThread().getContextClassLoader();
                }
                if (cl != null) {
                    return cl.loadClass(desc.getName());
                }
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                throw (ClassNotFoundException)ex;
            }
        }
    }
}

