/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type;

import java.util.Iterator;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.IncidenceSetRef;
import org.hypergraphdb.LazyRef;
import org.hypergraphdb.type.HGAtomTypeBase;
import org.hypergraphdb.type.HGProjection;
import org.hypergraphdb.type.RecordType;

public class RecordTypeConstructor
extends HGAtomTypeBase {
    @Override
    public Object make(HGPersistentHandle handle, LazyRef<HGHandle[]> targetSet, IncidenceSetRef incidenceSet) {
        RecordType result = new RecordType();
        result.setHyperGraph(this.graph);
        HGPersistentHandle[] layout = this.graph.getStore().getLink(handle);
        for (int i = 0; i < layout.length; ++i) {
            result.addSlot(layout[i]);
        }
        return result;
    }

    @Override
    public HGPersistentHandle store(Object instance) {
        RecordType recordType = (RecordType)instance;
        HGPersistentHandle[] layout = new HGPersistentHandle[recordType.slotCount()];
        for (int i = 0; i < layout.length; ++i) {
            layout[i] = this.graph.getPersistentHandle(recordType.getAt(i));
        }
        return this.graph.getStore().store(layout);
    }

    @Override
    public void release(HGPersistentHandle handle) {
        this.graph.getStore().removeLink(handle);
    }

    @Override
    public boolean subsumes(Object general, Object specific) {
        RecordType G = (RecordType)general;
        RecordType S = (RecordType)specific;
        Iterator<String> i = G.getDimensionNames();
        while (i.hasNext()) {
            HGProjection p = G.getProjection(i.next());
            HGProjection p2 = S.getProjection(p.getName());
            if (p2 != null && p.getType().equals(p2.getType())) continue;
            return false;
        }
        return true;
    }
}

