/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type;

import java.util.Map;
import org.hypergraphdb.HGEMissingData;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HGTypeSystem;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.IncidenceSetRef;
import org.hypergraphdb.LazyRef;
import org.hypergraphdb.type.HGAtomType;
import org.hypergraphdb.type.ObjectFactory;
import org.hypergraphdb.type.TypeUtils;

public class MapType
implements HGAtomType {
    private HyperGraph hg;
    private ObjectFactory<Map<Object, Object>> factory = null;

    public MapType(ObjectFactory<Map<Object, Object>> factory) {
        this.factory = factory;
    }

    public ObjectFactory<?> getFactory() {
        return this.factory;
    }

    @Override
    public void setHyperGraph(HyperGraph hg2) {
        this.hg = hg2;
    }

    @Override
    public Object make(HGPersistentHandle handle, LazyRef<HGHandle[]> targetSet, IncidenceSetRef incidenceSet) {
        Map<Object, Object> result = targetSet == null || targetSet.deref().length == 0 ? this.factory.make() : this.factory.make(targetSet.deref());
        TypeUtils.setValueFor(this.hg, handle, result);
        HGTypeSystem ts = this.hg.getTypeSystem();
        HGPersistentHandle[] layout = this.hg.getStore().getLink(handle);
        if (layout == null) {
            throw new HGEMissingData(handle);
        }
        int i = 0;
        while (i < layout.length) {
            HGPersistentHandle hType = layout[i++];
            HGAtomType type = ts.getType(hType);
            HGPersistentHandle hValue = layout[i++];
            Object key = TypeUtils.makeValue(this.hg, hValue, type);
            hType = layout[i++];
            hValue = layout[i++];
            if (hType.equals(this.hg.getHandleFactory().nullHandle())) {
                result.put(key, null);
                continue;
            }
            type = ts.getType(hType);
            Object value = TypeUtils.makeValue(this.hg, hValue, type);
            result.put(key, value);
        }
        return result;
    }

    @Override
    public HGPersistentHandle store(Object instance) {
        HGPersistentHandle result = TypeUtils.getNewHandleFor(this.hg, instance);
        Map map = (Map)instance;
        HGPersistentHandle[] layout = new HGPersistentHandle[map.size() * 4];
        int pos = 0;
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            HGHandle typeHandle = this.hg.getTypeSystem().getTypeHandle(key.getClass());
            if (typeHandle == null) {
                throw new HGException("Unable to get HG type for class '" + key.getClass() + "'");
            }
            layout[pos++] = this.hg.getPersistentHandle(typeHandle);
            layout[pos++] = TypeUtils.storeValue(this.hg, key, this.hg.getTypeSystem().getType(typeHandle));
            if (value == null) {
                layout[pos++] = this.hg.getHandleFactory().nullHandle();
                layout[pos++] = this.hg.getHandleFactory().nullHandle();
                continue;
            }
            typeHandle = this.hg.getTypeSystem().getTypeHandle(value.getClass());
            if (typeHandle == null) {
                throw new HGException("Unable to get HG type for class '" + value.getClass() + "'");
            }
            layout[pos++] = this.hg.getPersistentHandle(typeHandle);
            layout[pos++] = TypeUtils.storeValue(this.hg, value, this.hg.getTypeSystem().getType(typeHandle));
        }
        return this.hg.getStore().store(result, layout);
    }

    @Override
    public void release(HGPersistentHandle handle) {
        HGTypeSystem ts = this.hg.getTypeSystem();
        HGPersistentHandle[] layout = this.hg.getStore().getLink(handle);
        int i = 0;
        while (i < layout.length) {
            HGAtomType type;
            HGPersistentHandle hValue;
            HGPersistentHandle hType = layout[i++];
            if (!TypeUtils.isValueReleased(this.hg, hValue = layout[i++])) {
                type = ts.getType(hType);
                TypeUtils.releaseValue(this.hg, type, hValue);
                type.release(hValue);
            }
            hType = layout[i++];
            hValue = layout[i++];
            if (hType.equals(this.hg.getHandleFactory().nullHandle()) || TypeUtils.isValueReleased(this.hg, hValue)) continue;
            type = ts.getType(hType);
            TypeUtils.releaseValue(this.hg, type, hValue);
            type.release(hValue);
        }
        this.hg.getStore().removeLink(handle);
    }

    @Override
    public boolean subsumes(Object general, Object specific) {
        return false;
    }
}

