/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type;

import java.util.Iterator;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.IncidenceSetRef;
import org.hypergraphdb.LazyRef;
import org.hypergraphdb.type.BeanPropertyBasedProjection;
import org.hypergraphdb.type.HGCompositeType;
import org.hypergraphdb.type.HGProjection;
import org.hypergraphdb.type.JavaBeanBinding;

public class JavaAbstractBinding
implements HGCompositeType {
    protected HyperGraph graph;
    protected Class<?> javaClass;
    protected HGHandle typeHandle;
    protected HGCompositeType hgType;

    public JavaAbstractBinding(HGHandle typeHandle, HGCompositeType hgType, Class<?> clazz) {
        this.typeHandle = typeHandle;
        this.javaClass = clazz;
        this.hgType = hgType;
    }

    @Override
    public void setHyperGraph(HyperGraph hg2) {
        this.graph = hg2;
        this.hgType.setHyperGraph(hg2);
    }

    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    public HGCompositeType getHGType() {
        return this.hgType;
    }

    public HGHandle getTypeHandle() {
        return this.typeHandle;
    }

    @Override
    public Iterator<String> getDimensionNames() {
        return this.hgType.getDimensionNames();
    }

    @Override
    public HGProjection getProjection(String dimensionName) {
        HGProjection p = this.hgType.getProjection(dimensionName);
        if (p == null) {
            throw new HGException("Could not find projection for '" + dimensionName + "' in HG type " + this.typeHandle + " for " + this.javaClass.getName());
        }
        return new BeanPropertyBasedProjection(p);
    }

    @Override
    public Object make(HGPersistentHandle handle, LazyRef<HGHandle[]> targetSet, IncidenceSetRef incidenceSet) {
        throw new HGException("Cannot create a run-time instance of a HGAbstractType:" + this.javaClass.getName());
    }

    @Override
    public HGPersistentHandle store(Object instance) {
        throw new HGException("Cannot store and instance of a HGAbstractType in the database:" + this.javaClass.getName());
    }

    @Override
    public void release(HGPersistentHandle handle) {
        throw new HGException("Cannot release an instance of a HGAbstractType:" + this.javaClass.getName());
    }

    @Override
    public boolean subsumes(Object general, Object specific) {
        return general.getClass().isAssignableFrom(specific.getClass());
    }

    public boolean equals(Object other) {
        if (!(other instanceof JavaBeanBinding)) {
            return false;
        }
        JavaAbstractBinding otherJB = (JavaAbstractBinding)other;
        return this.typeHandle.equals(otherJB.typeHandle) && this.javaClass.isAssignableFrom(otherJB.javaClass);
    }

    public String toString() {
        return this.javaClass.toString();
    }
}

