/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type;

import java.util.Comparator;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.handle.HGLiveHandle;
import org.hypergraphdb.type.javaprimitive.PrimitiveTypeBase;

public class HGHandleType
extends PrimitiveTypeBase<HGHandle> {
    private static final HandleComparator comp = new HandleComparator();
    public static final String INDEX_NAME = "hg_handle_value_index";

    @Override
    protected String getIndexName() {
        return INDEX_NAME;
    }

    @Override
    protected HGHandle readBytes(byte[] data, int offset) {
        return this.graph.getHandleFactory().makeHandle(data, offset);
    }

    @Override
    protected byte[] writeBytes(HGHandle value) {
        if (value instanceof HGPersistentHandle) {
            return ((HGPersistentHandle)value).toByteArray();
        }
        return ((HGLiveHandle)value).getPersistentHandle().toByteArray();
    }

    @Override
    public Comparator<byte[]> getComparator() {
        return comp;
    }

    public static class HandleComparator
    implements Comparator<byte[]> {
        @Override
        public int compare(byte[] left, byte[] right) {
            for (int i = 4; i < left.length && i < right.length; ++i) {
                if (left[i] - right[i] == 0) continue;
                return left[i] - right[i];
            }
            return 0;
        }
    }
}

