/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type;

import java.util.HashMap;
import java.util.Iterator;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.type.HGAbstractType;
import org.hypergraphdb.type.HGCompositeType;
import org.hypergraphdb.type.HGProjection;

public class HGAbstractCompositeType
extends HGAbstractType
implements HGCompositeType {
    private HashMap<String, Projection> projections = new HashMap();

    public void addProjection(Projection p) {
        this.projections.put(p.getName(), p);
    }

    public void removeProjection(String name) {
        this.projections.remove(name);
    }

    @Override
    public Iterator<String> getDimensionNames() {
        return this.projections.keySet().iterator();
    }

    @Override
    public HGProjection getProjection(String dimensionName) {
        return this.projections.get(dimensionName);
    }

    public static class Projection
    implements HGProjection {
        private String name;
        private HGHandle type;

        public Projection(String name, HGHandle type) {
            this.name = name;
            this.type = type;
        }

        @Override
        public int[] getLayoutPath() {
            return null;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public HGHandle getType() {
            return this.type;
        }

        @Override
        public void inject(Object atomValue, Object value) {
            throw new HGException("Cannot inject value using an abstract type.");
        }

        @Override
        public Object project(Object atomValue) {
            throw new HGException("Cannot project value using an abstract type.");
        }
    }
}

